<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\FilterRequest\HotelReviewRequest;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class HolidayType
 *
 * @package Vtours\TTXmlWebService\Model\Request\FilterRequest\HotelReviewRequest
 */
class HolidayType
{
    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("HolidayType")
     */
    private $holidayType;

    /**
     * HolidayType constructor.
     *
     * @param string $holidayType
     */
    public function __construct($holidayType)
    {
        $this->holidayType = $holidayType;
    }

    /**
     * @return string
     */
    public function getHolidayType()
    {
        return $this->holidayType;
    }

    /**
     * @param string $holidayType
     *
     * @return HolidayType
     */
    public function setHolidayType($holidayType)
    {
        $this->holidayType = $holidayType;

        return $this;
    }

}
