<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\FilterRequest\HotelReviewRequest;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class HotelReview
 *
 * @package Vtours\TTXmlWebService\Model\Request\FilterRequest\HotelReviewRequest
 */
class HotelReview
{
    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("NumberOfRatings")
     */
    private $numberOfRatings;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("TotalRecommendation")
     */
    private $totalRecommendation;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingOverAll")
     */
    private $ratingOverAll;

    /**
     * @var TravellerType
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\HotelReviewRequest\TravellerType")
     * @Serializer\SerializedName("TravellerType")
     */
    private $travellerType;

    /**
     * @var HolidayType
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\HotelReviewRequest\HolidayType")
     * @Serializer\SerializedName("HolidayType")
     */
    private $holidayType;

    /**
     * HotelReview constructor
     */
    public function __construct($holidayType)
    {
        $this->travellerType = new TravellerType('ANY');
        $this->holidayType = new HolidayType($holidayType);
    }

    /**
     * @return int
     */
    public function getNumberOfRatings()
    {
        return $this->numberOfRatings;
    }

    /**
     * @param int $numberOfRatings
     *
     * @return HotelReview
     */
    public function setNumberOfRatings($numberOfRatings)
    {
        $this->numberOfRatings = $numberOfRatings;

        return $this;
    }

    /**
     * @return float
     */
    public function getTotalRecommendation()
    {
        return $this->totalRecommendation;
    }

    /**
     * @param float $totalRecommendation
     *
     * @return HotelReview
     */
    public function setTotalRecommendation($totalRecommendation)
    {
        $this->totalRecommendation = $totalRecommendation;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingOverAll()
    {
        return $this->ratingOverAll;
    }

    /**
     * @param float $ratingOverAll
     *
     * @return HotelReview
     */
    public function setRatingOverAll($ratingOverAll)
    {
        $this->ratingOverAll = $ratingOverAll;

        return $this;
    }

    /**
     * @return TravellerType
     */
    public function getTravellerType()
    {
        return $this->travellerType;
    }

    /**
     * @param TravellerType $travellerType
     *
     * @return HotelReview
     */
    public function setTravellerType($travellerType)
    {
        $this->travellerType = $travellerType;

        return $this;
    }

    /**
     * @return HolidayType
     */
    public function getHolidayType()
    {
        return $this->holidayType;
    }

    /**
     * @param HolidayType $holidayType
     *
     * @return HotelReview
     */
    public function setHolidayType($holidayType)
    {
        $this->holidayType = $holidayType;

        return $this;
    }

}
