<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request;


use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Request\FilterRequest\Filter;
use Vtours\TTXmlWebService\Model\Request\SearchRequest\Search;

/**
 * @Serializer\XmlRoot("t:SearchEngineCityListRQ")
 * @Serializer\AccessType("public_method")
 * @Serializer\XmlNamespace(uri="http://traveltainment.de/middleware/xml/SearchEngineCityListRQ", prefix="t")
 */
class SearchEngineCityListRQ extends SearchEngineRQ
{

    /**
     * @var Search
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SearchRequest\Search")
     * @Serializer\SerializedName("Search")
     */
    private $search;


    /**
     * @var Filter
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\FilterRequest\Filter")
     * @Serializer\SerializedName("Filter")
     */
    private $filter;

    public function __construct(array $duration, $mealType, array $cityIds, array $topRegionIds)
    {
        parent::__construct();
        $this->search = new Search('CityList', $duration, $mealType);
        $this->filter = new Filter('CityList', $cityIds, $topRegionIds, null);
    }

    /**
     * @return Search
     */
    public function getSearch()
    {
        return $this->search;
    }

    /**
     * @param Search $search
     *
     * @return SearchEngineCityListRQ
     */
    public function setSearch($search)
    {
        $this->search = $search;

        return $this;
    }

    /**
     * @return Filter
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * @param Filter $filter
     *
     * @return SearchEngineCityListRQ
     */
    public function setFilter($filter)
    {
        $this->filter = $filter;

        return $this;
    }

}
