<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\SearchRequest;


use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\Trip;

/**
 * Class Search
 *
 * @package Vtours\TTXmlWebService\Model\Request\SearchRequest
 */
class Search
{
    /**
     * @var Trip
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\Trip")
     * @Serializer\SerializedName("Trip")
     */
    private $trip;

    /**
     * @var Options
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SearchRequest\Options")
     * @Serializer\SerializedName("Options")
     */
    private $options;

    public function __construct($root, array $duration, array $durationPeriod, $mealType, $traveller)
    {
        $this->trip = new Trip($duration, $durationPeriod, $mealType, $traveller);
        $this->options = new Options($root);


    }

    /**
     * @return Trip
     */
    public function getTrip()
    {
        return $this->trip;
    }

    /**
     * @param Trip $trip
     *
     * @return Search
     */
    public function setTrip($trip)
    {
        $this->trip = $trip;

        return $this;
    }

    /**
     * @return Options
     */
    public function getOptions()
    {
        return $this->options;
    }

    /**
     * @param Options $options
     *
     * @return Search
     */
    public function setOptions($options)
    {
        $this->options = $options;

        return $this;
    }

}
