<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\FlightResponse;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class InAndOutboundFlightSegments
 *
 * @package Vtours\TTXmlWebService\Model\Response\FlightResponse
 */
class InAndOutboundFlightSegments
{

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ProgramType")
     */
    private $programType;

    /**
     * @var string
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\FlightResponse\Airport")
     * @Serializer\SerializedName("DepartureAirport")
     */
    private $departureAirport;

    /**
     * @var string
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\FlightResponse\Airport")
     * @Serializer\SerializedName("DestinationAirport")
     */
    private $destinationAirport;

    /**
     * @var int
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\FlightResponse\FlightDateTimeSpan")
     * @Serializer\SerializedName("FlightDateTimeSpan")
     */
    private $flightDateTimeSpan;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("BoardingCode")
     */
    private $boardingCode;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("CarrierCode")
     */
    private $carrierCode;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("FlightCode")
     */
    private $flightCode;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("LegCode")
     */
    private $legCode;

    /**
     * @var FlightSegment
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\FlightResponse\FlightSegment")
     * @Serializer\SerializedName("FlightSegment")
     */
    private $flightSegment;

    /**
     * @return string
     */
    public function getProgramType()
    {
        return $this->programType;
    }

    /**
     * @param string $programType
     *
     * @return InAndOutboundFlightSegments
     */
    public function setProgramType($programType)
    {
        $this->programType = $programType;

        return $this;
    }

    /**
     * @return string
     */
    public function getDepartureAirport()
    {
        return $this->departureAirport;
    }

    /**
     * @param string $departureAirport
     *
     * @return InAndOutboundFlightSegments
     */
    public function setDepartureAirport($departureAirport)
    {
        $this->departureAirport = $departureAirport;

        return $this;
    }

    /**
     * @return string
     */
    public function getDestinationAirport()
    {
        return $this->destinationAirport;
    }

    /**
     * @param string $destinationAirport
     *
     * @return InAndOutboundFlightSegments
     */
    public function setDestinationAirport($destinationAirport)
    {
        $this->destinationAirport = $destinationAirport;

        return $this;
    }

    /**
     * @return int
     */
    public function getFlightDateTimeSpan()
    {
        return $this->flightDateTimeSpan;
    }

    /**
     * @param int $flightDateTimeSpan
     *
     * @return InAndOutboundFlightSegments
     */
    public function setFlightDateTimeSpan($flightDateTimeSpan)
    {
        $this->flightDateTimeSpan = $flightDateTimeSpan;

        return $this;
    }

    /**
     * @return string
     */
    public function getBoardingCode()
    {
        return $this->boardingCode;
    }

    /**
     * @param string $boardingCode
     *
     * @return InAndOutboundFlightSegments
     */
    public function setBoardingCode($boardingCode)
    {
        $this->boardingCode = $boardingCode;

        return $this;
    }

    /**
     * @return string
     */
    public function getCarrierCode()
    {
        return $this->carrierCode;
    }

    /**
     * @param string $carrierCode
     *
     * @return InAndOutboundFlightSegments
     */
    public function setCarrierCode($carrierCode)
    {
        $this->carrierCode = $carrierCode;

        return $this;
    }

    /**
     * @return string
     */
    public function getFlightCode()
    {
        return $this->flightCode;
    }

    /**
     * @param string $flightCode
     *
     * @return InAndOutboundFlightSegments
     */
    public function setFlightCode($flightCode)
    {
        $this->flightCode = $flightCode;

        return $this;
    }

    /**
     * @return string
     */
    public function getLegCode()
    {
        return $this->legCode;
    }

    /**
     * @param string $legCode
     *
     * @return InAndOutboundFlightSegments
     */
    public function setLegCode($legCode)
    {
        $this->legCode = $legCode;

        return $this;
    }

    /**
     * @return FlightSegment
     */
    public function getFlightSegment()
    {
        return $this->flightSegment;
    }

    /**
     * @param FlightSegment $flightSegment
     *
     * @return InAndOutboundFlightSegments
     */
    public function setFlightSegment($flightSegment)
    {
        $this->flightSegment = $flightSegment;

        return $this;
    }

}
