<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;


use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Response\FlightResponse\Flight;

/**
 * Class Package
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class Package
{
    /**
     * @var Accommodation
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\Accommodation")
     * @Serializer\SerializedName("Accommodation")
     */
    private $accommodation;

    /**
     * @var Flight
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\FlightResponse\Flight")
     * @Serializer\SerializedName("Flight")
     */
    private $flight;


    /**
     * @return Flight
     */
    public function getFlight()
    {
        return $this->flight;
    }

    /**
     * @param Flight $flight
     *
     * @return Package
     */
    public function setFlight($flight)
    {
        $this->flight = $flight;

        return $this;
    }

    /**
     * @return Accommodation
     */
    public function getAccommodation()
    {
        return $this->accommodation;
    }

    /**
     * @param Accommodation $accommodation
     *
     * @return Package
     */
    public function setAccommodation($accommodation)
    {
        $this->accommodation = $accommodation;

        return $this;
    }
}
