<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class ResultSummary
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class ResultSummary
{
    /**
     * @var Cities
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\Cities")
     * @Serializer\SerializedName("Cities")
     */
    private $cities;

    /**
     * @return Cities
     */
    public function getCities()
    {
        return $this->cities;
    }

    /**
     * @param Cities $cities
     *
     * @return ResultSummary
     */
    public function setCities($cities)
    {
        $this->cities = $cities;

        return $this;
    }
}
