<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request;

use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Request\SearchRequest\Search;
use Vtours\TTXmlWebService\Model\Request\SelectionRequest\Selection;


/**
 * @Serializer\XmlRoot("t:SearchEngineOfferListRQ")
 * @Serializer\AccessType("public_method")
 * @Serializer\XmlNamespace(uri="http://traveltainment.de/middleware/xml/SearchEngineOfferListRQ", prefix="t")
 */
class SearchEngineOfferListRQ extends SearchEngineRQ
{

    /**
     * @var Search
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SearchRequest\Search")
     * @Serializer\SerializedName("Search")
     */
    private $search;

    /**
     * @var Selection
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SelectionRequest\Selection")
     * @Serializer\SerializedName("Selection")
     */
    private $selection;

    public function __construct(
    array $durationDays,
    array $durationPeriod,
    array $pricing,
    array $hotelAttributes,
    $mealType,
    array $travellers,
    array $specialJourneyAttributes,
    $brand,
    $departureAirport,
    $hotelId,
    $hotelCodeType
) {
    parent::__construct();
    $this->search = new Search('OfferList', $durationDays, $durationPeriod, $pricing, $hotelAttributes, $mealType, $travellers,
        $specialJourneyAttributes, $brand, $departureAirport);
    $this->selection = new Selection('OfferList', $hotelId, $hotelCodeType, []);
}


    /**
     * @return Search
     */
    public function getSearch()
    {
        return $this->search;
    }

    /**
     * @param Search $search
     *
     * @return SearchEngineOfferListRQ
     */
    public function setSearch($search)
    {
        $this->search = $search;

        return $this;
    }

    /**
     * @return Selection
     */
    public function getSelection()
    {
        return $this->selection;
    }

    /**
     * @param Selection $selection
     *
     * @return SearchEngineOfferListRQ
     */
    public function setSelection($selection)
    {
        $this->selection = $selection;

        return $this;
    }
}
