<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class SearchEngineRQ
 *
 * @package Vtours\TTXmlWebService\Model\Request
 */
class SearchEngineRQ
{
    /**
     * @var \DateTime
     * @Serializer\XmlAttribute()
     * @Serializer\SerializedName("Timestamp")
     */
    private $timestamp;

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\SerializedName("Target")
     */
    private $target;

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\SerializedName("LanguageCode")
     */
    private $languageCode;

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\SerializedName("TrackingID")
     */
    private $trackingID;

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\SerializedName("ClientSessionID")
     */
    private $clientSessionID;

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\SerializedName("ClientIP")
     */
    private $clientIP;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("CID")
     */
    private $cid;

    public function __construct()
    {
        $dt = new \DateTime('now');
        $this->timestamp = $dt->format(DATE_ATOM);

        $this->target = 'Test'; //'Production' für Livesystem
        $this->languageCode = "de-DE";
        $this->trackingID = '22'; //?
        $this->clientSessionID = '11'; //?
        $this->clientIP = '111.222.333.44'; //request-ip

        $this->cid = '12345678';
    }

    /**
     * @return \DateTime
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }

    /**
     * @param \DateTime $timestamp
     *
     * @return SearchEngineRQ
     */
    public function setTimestamp($timestamp)
    {
        $this->timestamp = $timestamp;

        return $this;
    }

    /**
     * @return string
     */
    public function getTarget()
    {
        return $this->target;
    }

    /**
     * @param string $target
     *
     * @return SearchEngineRQ
     */
    public function setTarget($target)
    {
        $this->target = $target;

        return $this;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }

    /**
     * @param string $languageCode
     *
     * @return SearchEngineRQ
     */
    public function setLanguageCode($languageCode)
    {
        $this->languageCode = $languageCode;

        return $this;
    }

    /**
     * @return string
     */
    public function getTrackingID()
    {
        return $this->trackingID;
    }

    /**
     * @param string $trackingID
     *
     * @return SearchEngineRQ
     */
    public function setTrackingID($trackingID)
    {
        $this->trackingID = $trackingID;

        return $this;
    }

    /**
     * @return string
     */
    public function getClientSessionID()
    {
        return $this->clientSessionID;
    }

    /**
     * @param string $clientSessionID
     *
     * @return SearchEngineRQ
     */
    public function setClientSessionID($clientSessionID)
    {
        $this->clientSessionID = $clientSessionID;

        return $this;
    }

    /**
     * @return string
     */
    public function getClientIP()
    {
        return $this->clientIP;
    }

    /**
     * @param string $clientIP
     *
     * @return SearchEngineRQ
     */
    public function setClientIP($clientIP)
    {
        $this->clientIP = $clientIP;

        return $this;
    }

    /**
     * @return string
     */
    public function getCid()
    {
        return $this->cid;
    }

    /**
     * @param string $cid
     *
     * @return SearchEngineRQ
     */
    public function setCid($cid)
    {
        $this->cid = $cid;

        return $this;
    }
}
