<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest;


use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\Journey;

/**
 * Class Trip
 *
 * @package Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest
 */
class Trip
{

    /**
     * @var Journey
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\Journey")
     * @Serializer\SerializedName("Journey")
     */
    private $journey;

    /**
     * @var Hotel
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\Hotel")
     * @Serializer\SerializedName("Hotel")
     */
    private $hotel;

    /**
     * @var TourOperator
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\TourOperator")
     * @Serializer\SerializedName("TourOperator")
     */
    private $tourOperator;


    public function __construct(
        array $duration,
        array $durationPeriod,
        array $pricing,
        array $hotelAttributes,
        $mealType,
        array $travellers,
        array $specialJourneyAttributes,
        $brand,
        $departureAirport
    ) {
        $this->journey = new Journey($duration, $durationPeriod, $pricing, $travellers, $specialJourneyAttributes, $departureAirport);
        $this->hotel = new Hotel($mealType, $hotelAttributes);
        $this->tourOperator = new TourOperator($brand);
    }

    /**
     * @return Journey
     */
    public function getJourney()
    {
        return $this->journey;
    }

    /**
     * @param Journey $journey
     *
     * @return Trip
     */
    public function setJourney($journey)
    {
        $this->journey = $journey;

        return $this;
    }

    /**
     * @return Hotel
     */
    public function getHotel()
    {
        return $this->hotel;
    }

    /**
     * @param Hotel $hotel
     *
     * @return Trip
     */
    public function setHotel($hotel)
    {
        $this->hotel = $hotel;

        return $this;
    }

    /**
     * @return TourOperator
     */
    public function getTourOperator()
    {
        return $this->tourOperator;
    }

    /**
     * @param TourOperator $tourOperator
     *
     * @return Trip
     */
    public function setTourOperator($tourOperator)
    {
        $this->tourOperator = $tourOperator;

        return $this;
    }

}
