<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class ObjectImages
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class ObjectImages
{
    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Thumbnail")
     */
    private $thumbnail;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("MediumImage")
     */
    private $mediumImage;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("LargeImage")
     */
    private $largeImage;

    /**
     * ObjectImages constructor.
     *
     * @param string $thumbnail
     * @param string $mediumImage
     * @param string $largeImage
     */
    public function __construct($thumbnail, $mediumImage, $largeImage)
    {
        $this->thumbnail = $thumbnail;
        $this->mediumImage = $mediumImage;
        $this->largeImage = $largeImage;
    }

    /**
     * @return string
     */
    public function getThumbnail()
    {
        return $this->thumbnail;
    }

    /**
     * @param string $thumbnail
     *
     * @return ObjectImages
     */
    public function setThumbnail($thumbnail)
    {
        $this->thumbnail = $thumbnail;

        return $this;
    }

    /**
     * @return string
     */
    public function getMediumImage()
    {
        return $this->mediumImage;
    }

    /**
     * @param string $mediumImage
     *
     * @return ObjectImages
     */
    public function setMediumImage($mediumImage)
    {
        $this->mediumImage = $mediumImage;

        return $this;
    }

    /**
     * @return string
     */
    public function getLargeImage()
    {
        return $this->largeImage;
    }

    /**
     * @param string $largeImage
     *
     * @return ObjectImages
     */
    public function setLargeImage($largeImage)
    {
        $this->largeImage = $largeImage;

        return $this;
    }
}
