<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class RegionCity
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class RegionCity
{
    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     */
    private $name;

    /**
     * @var City
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\City")
     * @Serializer\SerializedName("City")
     */
    private $city;

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return RegionCity
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return City
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @param City $city
     *
     * @return RegionCity
     */
    public function setCity($city)
    {
        $this->city = $city;

        return $this;
    }
}
