<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class ResultSet
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class ResultSet
{
    /**
     * @Serializer\Type("int")
     * @Serializer\XmlAttribute()
     * @Serializer\SerializedName("TotalNumberOfResults")
     */
    private $totalNumberOfResults;

    /**
     * @Serializer\XmlList(inline = true, entry = "ListItem")
     * @Serializer\Type("array <Vtours\TTXmlWebService\Model\Response\ListItem>")
     * @Serializer\SerializedName("ListItem")
     */
    private $listItem;

    /**
     * ResultSet constructor.
     *
     * @param ListItem[] $listItem
     * @param int        $totalNumberOfResults
     */
    public function __construct(array $listItem, $totalNumberOfResults)
    {
        $this->totalNumberOfResults = $totalNumberOfResults;
        $this->listItem = $listItem;

    }

    /**
     * @return ListItem[]
     */
    public function getListItem()
    {
        return $this->listItem;
    }

    /**
     * @param ListItem[] $listItem
     *
     * @return ResultSet
     */
    public function setListItem($listItem)
    {
        $this->listItem = $listItem;

        return $this;
    }

    /**
     * @return int
     */
    public function getTotalNumberOfResults()
    {
        return $this->totalNumberOfResults;
    }

    /**
     * @param int $totalNumberOfResults
     *
     * @return ResultSet
     */
    public function setTotalNumberOfResults($totalNumberOfResults)
    {
        $this->totalNumberOfResults = $totalNumberOfResults;

        return $this;
    }
}
