<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\FilterRequest;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class CityIDList
 *
 * @package Vtours\TTXmlWebService\Model\Request\FilterRequest
 */
class CityIDList
{
    /**
     * @var array<int>
     * @Serializer\XmlList(inline = true, entry = "CityID")
     * @Serializer\SerializedName("CityIDList")
     */
    private $cityIdList;

    /**
     * @var array
     * @Serializer\XmlAttribute()
     * @Serializer\SerializedName("TopRegionIDs")
     */
    private $topRegionIds;

    public function __construct($cityIds, $topRegionIds)
    {
        $this->cityIdList = $cityIds;
        $this->topRegionIds = implode($topRegionIds);
    }
}
