<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\TravelDateRequest;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class TravelDurationSpan
 *
 * @package Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\TravelDateRequest\TravelDateRequest
 */
class TravelDurationSpan
{
    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("MinDays")
     */
    private $minDays;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("MaxDays")
     */
    private $maxDays;

    /**
     * @var int
     * @Serializer\XmlAttribute()
     * @Serializer\SerializedName("Weightage")
     */
    private $weightage;

    /**
     * TravelDurationSpan constructor.
     *
     * @param array $duration
     */
    public function __construct(array $duration)
    {
        if (!empty($duration[0])) {
            $this->minDays = $duration[0];
        }
        if (!empty($duration[1])) {
            $this->maxDays = $duration[1];
        }
    }

    /**
     * @return int
     */
    public function getMinDays()
    {
        return $this->minDays;
    }

    /**
     * @param int $minDays
     *
     * @return TravelDurationSpan
     */
    public function setMinDays($minDays)
    {
        $this->minDays = $minDays;

        return $this;
    }

    /**
     * @return int
     */
    public function getMaxDays()
    {
        return $this->maxDays;
    }

    /**
     * @param int $maxDays
     *
     * @return TravelDurationSpan
     */
    public function setMaxDays($maxDays)
    {
        $this->maxDays = $maxDays;

        return $this;
    }

    /**
     * @return int
     */
    public function getWeightage()
    {
        return $this->weightage;
    }

    /**
     * @param int $weightage
     *
     * @return TravelDurationSpan
     */
    public function setWeightage($weightage)
    {
        $this->weightage = $weightage;

        return $this;
    }


}
