<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\SelectionRequest;


use JMS\Serializer\Annotation as Serializer;


/**
 * Class Selection
 *
 * @Serializer\XmlRoot("Selection")
 * @package Vtours\TTXmlWebService\Model\Request
 */
class Selection
{
    /**
     * @var HotelSelection
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SelectionRequest\HotelSelection")
     * @Serializer\SerializedName("HotelSelection")
     */
    private $hotelSelection;

    /**
     * @var string
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SelectionRequest\ObjectID")
     * @Serializer\SerializedName("ObjectIDs")
     */
    private $objectIds;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("RegionIDs")
     */
    private $regionIds;

    public function __construct($root, $hotelId, $hotelCodeType, $regionId)
    {
        if ($root == 'OfferList') {
            $this->hotelSelection = new HotelSelection($hotelId, $hotelCodeType);
        } else {
            if ($root == 'HotelList' && $hotelId != null) {
                $this->objectIds = new ObjectId($hotelId, $hotelCodeType);
            } else {
                if ($root = 'HotelList' && $hotelId == null) {
                    $this->regionIds = $regionId;
                }
            }
        }
    }
}
