<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class Regions
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class Regions
{
    /**
     * @var array <SubRegion>
     * @Serializer\XmlList(inline = true, entry = "SubRegion")
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\SubRegion>")
     * @Serializer\SerializedName("SubRegion")
     */
    private $subRegions;

    /**
     * @return array
     */
    public function getSubRegions()
    {
        return $this->subRegions;
    }

    /**
     * @param array $subRegions
     *
     * @return Regions
     */
    public function setSubRegions($subRegions)
    {
        $this->subRegions = $subRegions;

        return $this;
    }
}
