<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\FilterRequest;


use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Request\FilterRequest\HotelReviewRequest\HotelReview;

/**
 * Class Filter
 *
 * @package Vtours\TTXmlWebService\Model\Request\FilterRequest
 */
class Filter
{

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("OfferScope")
     */
    private $offerScope;

    /**
     * @var CityIDList
     * @Serializer\Type("VTours\TTXmlWebService\Model\Request\FilterRequest\CityIDList")
     * @Serializer\SerializedName("CityIDList")
     */
    private $cityIdList;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("CityIDs")
     */
    private $cityIds;


    /**
     * @var HotelReview
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\FilterRequest\HotelReviewRequest\HotelReview")
     * @Serializer\SerializedName("HotelReview")
     */
    private $hotelReview;


    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("FlightDuration")
     */
    private $flightDuration;

    public function __construct($root, array $cityIds, array $topRegionIds, $holidayType)
    {
        $this->offerScope = 'All';

        if ($root == 'HotelList') {
            $this->cityIds = implode(' ', $cityIds);
            $this->hotelReview = new HotelReview($holidayType);
        } else {
            if ($root == 'CityList') {
                $this->cityIdList = new CityIDList($cityIds, $topRegionIds);
            }
        }
    }


    /**
     * @return string
     */
    public function getOfferScope()
    {
        return $this->offerScope;
    }

    /**
     * @param string $offerScope
     *
     * @return Filter
     */
    public function setOfferScope($offerScope)
    {
        $this->offerScope = $offerScope;

        return $this;
    }

    /**
     * @return CityIDList
     */
    public function getCityIdList()
    {
        return $this->cityIdList;
    }

    /**
     * @param CityIDList $cityIdList
     *
     * @return Filter
     */
    public function setCityIdList($cityIdList)
    {
        $this->cityIdList = $cityIdList;

        return $this;
    }

    /**
     * @return string
     */
    public function getCityIds()
    {
        return $this->cityIds;
    }

    /**
     * @param string $cityIds
     *
     * @return Filter
     */
    public function setCityIds($cityIds)
    {
        $this->cityIds = $cityIds;

        return $this;
    }

    /**
     * @return HotelReview
     */
    public function getHotelReview()
    {
        return $this->hotelReview;
    }

    /**
     * @param HotelReview $hotelReview
     *
     * @return Filter
     */
    public function setHotelReview($hotelReview)
    {
        $this->hotelReview = $hotelReview;

        return $this;
    }

    /**
     * @return int
     */
    public function getFlightDuration()
    {
        return $this->flightDuration;
    }

    /**
     * @param int $flightDuration
     *
     * @return Filter
     */
    public function setFlightDuration($flightDuration)
    {
        $this->flightDuration = $flightDuration;

        return $this;
    }

}
