<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request;


use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Request\FilterRequest\Filter;
use Vtours\TTXmlWebService\Model\Request\SearchRequest\Search;
use Vtours\TTXmlWebService\Model\Request\SelectionRequest\Selection;

/**
 * Class SearchEngineHotelListRQ
 *
 * @package Vtours\TTXmlWebService\Model\Request
 * @Serializer\XmlRoot("t:SearchEngineHotelListRQ")
 * @Serializer\XmlNamespace(uri = "http://traveltainment.de/middleware/xml/SearchEngineHotelListRQ", prefix="t")
 */
class SearchEngineHotelListRQ extends SearchEngineRQ
{
    /**
     * @var Search
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SearchRequest\Search")
     * @Serializer\SerializedName("Search")
     */
    private $search;

    /**
     * @var Selection
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SelectionRequest\Selection")
     * @Serializer\SerializedName("Selection")
     */
    private $selection;

    /**
     * @var Filter
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\FilterRequest\Filter")
     * @Serializer\SerializedName("Filter")
     * CITYTRIP??
     */
    private $filter;

    /**
     * SearchEngineHotelListRQ constructor.
     *
     * @param $durationDays
     * @param $durationPeriod
     * @param $pricing
     * @param $hotelAttributes
     * @param $mealType
     * @param $roomType
     * @param $travellers
     * @param $specialJourneyAttributes
     * @param $brand
     * @param $departureAirport
     * @param $regionId
     */
    public function __construct(
        array $durationDays,
        array $durationPeriod,
        array $pricing,
        array $hotelAttributes,
        $mealType,
        $roomType,
        array $travellers,
        array $specialJourneyAttributes,
        $brand,
        $departureAirport,
        $regionId
    ) {
        parent::__construct();

        $this->search = new Search('HotelList', $durationDays, $durationPeriod, $pricing, $hotelAttributes, $mealType, $roomType, $travellers,
            $specialJourneyAttributes, $brand, $departureAirport);
        $this->selection = new Selection('HotelList', null, null, $regionId);
    }

    /**
     * @return Search
     */
    public function getSearch()
    {
        return $this->search;
    }

    /**
     * @param Search $search
     *
     * @return SearchEngineHotelListRQ
     */
    public function setSearch($search)
    {
        $this->search = $search;

        return $this;
    }

    /**
     * @return Selection
     */
    public function getSelection()
    {
        return $this->selection;
    }

    /**
     * @param Selection $selection
     *
     * @return SearchEngineHotelListRQ
     */
    public function setSelection($selection)
    {
        $this->selection = $selection;

        return $this;
    }

    /**
     * @return Filter
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * @param Filter $filter
     *
     * @return SearchEngineHotelListRQ
     */
    public function setFilter($filter)
    {
        $this->filter = $filter;

        return $this;
    }
}
