<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\SearchRequest;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class Options
 *
 * @package Vtours\TTXmlWebService\Model\Request\SearchRequest
 */
class Options
{
    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("ResultsPerPage")
     */
    private $resultsPerPage;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("ResultOffset")
     */
    private $resultOffset;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TeaserOptions")
     */
    private $teaserOptions;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("AdditionalCurrencies")
     */
    private $additionalCurrencies;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Sorting")
     */
    private $sorting;


    public function __construct($root)
    {
        if ($root != 'CityList') {
            $this->resultsPerPage = 10;
            $this->resultOffset = 0;
            $this->sorting = 'PRICE';
            $this->additionalCurrencies = 'EUR';
        } else {
            if ($root == 'CityList') {
                $this->additionalCurrencies = 'EUR';
            }
        }

    }

    /**
     * @return int
     */
    public function getResultsPerPage()
    {
        return $this->resultsPerPage;
    }

    /**
     * @param int $resultsPerPage
     *
     * @return Options
     */
    public function setResultsPerPage($resultsPerPage)
    {
        $this->resultsPerPage = $resultsPerPage;

        return $this;
    }

    /**
     * @return int
     */
    public function getResultOffset()
    {
        return $this->resultOffset;
    }

    /**
     * @param int $resultOffset
     *
     * @return Options
     */
    public function setResultOffset($resultOffset)
    {
        $this->resultOffset = $resultOffset;

        return $this;
    }

    /**
     * @return string
     */
    public function getTeaserOptions()
    {
        return $this->teaserOptions;
    }

    /**
     * @param string $teaserOptions
     *
     * @return Options
     */
    public function setTeaserOptions($teaserOptions)
    {
        $this->teaserOptions = $teaserOptions;

        return $this;
    }

    /**
     * @return string
     */
    public function getAdditionalCurrencies()
    {
        return $this->additionalCurrencies;
    }

    /**
     * @param string $additionalCurrencies
     *
     * @return Options
     */
    public function setAdditionalCurrencies($additionalCurrencies)
    {
        $this->additionalCurrencies = $additionalCurrencies;

        return $this;
    }

    /**
     * @return string
     */
    public function getSorting()
    {
        return $this->sorting;
    }

    /**
     * @param string $sorting
     *
     * @return Options
     */
    public function setSorting($sorting)
    {
        $this->sorting = $sorting;

        return $this;
    }
}
