<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest;

use JMS\Serializer\Annotation as Serializer;

class DepartureAirportList
{


    /**
     * @var array<string>
     * @Serializer\XmlList(inline = true, entry ="Airport")
     * @Serializer\SerializedName("Airport")
     */
    private $departureAirportList;

    /**
     * @var int
     * @Serializer\XmlAttribute()
     * @Serializer\SerializedName("Weightage")
     */
    private $weightage;


    public function __construct($departureAirportList)
    {
        if ($departureAirportList != null || $departureAirportList != '') {
            $this->departureAirportList = [$departureAirportList];
            $this->weightage = 50;
        }
    }

    /**
     * @return array
     */
    public function getDepartureAirportList()
    {
        return $this->departureAirportList;
    }

    /**
     * @param array $departureAirportList
     *
     * @return DepartureAirportList
     */
    public function setDepartureAirportList($departureAirportList)
    {
        $this->departureAirportList = $departureAirportList;

        return $this;
    }

    /**
     * @return int
     */
    public function getWeightage()
    {
        return $this->weightage;
    }

    /**
     * @param int $weightage
     *
     * @return DepartureAirportList
     */
    public function setWeightage($weightage)
    {
        $this->weightage = $weightage;

        return $this;
    }
}
