<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class Category
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class Category
{
    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("Stars")
     */
    private $stars;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("MinStars")
     */
    private $minStars;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("MaxStars")
     */
    private $maxStars;

    /**
     * Category constructor.
     *
     * @param int $stars
     * @param int $minStars
     * @param int $maxStars
     */
    public function __construct($stars, $minStars, $maxStars)
    {
        $this->stars = $stars;
        $this->minStars = $minStars;
        $this->maxStars = $maxStars;
    }

    /**
     * @return int
     */
    public function getStars()
    {
        return $this->stars;
    }

    /**
     * @param int $stars
     *
     * @return Category
     */
    public function setStars($stars)
    {
        $this->stars = $stars;

        return $this;
    }

    /**
     * @return int
     */
    public function getMinStars()
    {
        return $this->minStars;
    }

    /**
     * @param int $minStars
     *
     * @return Category
     */
    public function setMinStars($minStars)
    {
        $this->minStars = $minStars;

        return $this;
    }

    /**
     * @return int
     */
    public function getMaxStars()
    {
        return $this->maxStars;
    }

    /**
     * @param int $maxStars
     *
     * @return Category
     */
    public function setMaxStars($maxStars)
    {
        $this->maxStars = $maxStars;

        return $this;
    }

}
