<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;


use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Response\PriceResponse\PriceInformation;

/**
 * Class Offer
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class Offer
{
    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("OfferID")
     */
    private $offerId;

    /**
     * @var PriceInformation
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\PriceResponse\PriceInformation")
     * @Serializer\SerializedName("PriceInformation")
     */
    private $priceInformation;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("Weightage")
     */
    private $weightage;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("TravelDuration")
     */
    private $travelDuration;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("AverageFlightDuration")
     */
    private $averageFlightDuration;

    /**
     * @var bool
     * @Serializer\Type("boolean")
     * @Serializer\SerializedName("Alternative")
     */
    private $alternative;

    /**
     * @var bool
     * @Serializer\Type("boolean")
     * @Serializer\SerializedName("Exclusive")
     */
    private $exclusive;

    /**
     * @var TourOperator
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\TourOperator")
     * @Serializer\SerializedName("TourOperator")
     */
    private $tourOperator;

    /**
     * @var \DateTime
     * @Serializer\Type("DateTime<'Y-m-d\+H:i'>")
     * @Serializer\SerializedName("DepartureDate")
     */
    private $departureDate;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("SpecialJourneyAttributes")
     */
    private $specialJourneyAttributes;


    /**
     * @var Package
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\Package")
     * @Serializer\SerializedName("Package")
     */
    private $package;

    /**
     * @var Accommodation
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\Accommodation")
     * @Serializer\SerializedName("Accommodation")
     */
    private $accommodation;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TravelType")
     */
    private $travelType;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ProgramType")
     */
    private $programType;

    /**
     * @var bool
     * @Serializer\Type("boolean")
     * @Serializer\SerializedName("FlightBookedOut")
     */
    private $flightBookedOut;

    /**
     * @var bool
     * @Serializer\Type("boolean")
     * @Serializer\SerializedName("AccommodationBookedOut")
     */
    private $AccommodationBookedOut;

    /**
     * @var array<string>
     * @Serializer\XmlList(entry = "Attribute")
     * @Serializer\Type("array<string>")
     * @Serializer\SerializedName("TourOperatorAttributes")
     */
    private $tourOperatorAttributes;

    /**
     * @return Accommodation
     */
    public function getAccommodation()
    {
        return $this->accommodation;
    }

    /**
     * @param Accommodation $accommodation
     *
     * @return Offer
     */
    public function setAccommodation($accommodation)
    {
        $this->accommodation = $accommodation;

        return $this;
    }


    /**
     * @return int
     */
    public function getOfferId()
    {
        return $this->offerId;
    }

    /**
     * @param int $offerId
     *
     * @return Offer
     */
    public function setOfferId($offerId)
    {
        $this->offerId = $offerId;

        return $this;
    }

    /**
     * @return PriceInformation
     */
    public function getPriceInformation()
    {
        return $this->priceInformation;
    }

    /**
     * @param PriceInformation $priceInformation
     *
     * @return Offer
     */
    public function setPriceInformation($priceInformation)
    {
        $this->priceInformation = $priceInformation;

        return $this;
    }

    /**
     * @return int
     */
    public function getWeightage()
    {
        return $this->weightage;
    }

    /**
     * @param int $weightage
     *
     * @return Offer
     */
    public function setWeightage($weightage)
    {
        $this->weightage = $weightage;

        return $this;
    }

    /**
     * @return int
     */
    public function getTravelDuration()
    {
        return $this->travelDuration;
    }

    /**
     * @param int $travelDuration
     *
     * @return Offer
     */
    public function setTravelDuration($travelDuration)
    {
        $this->travelDuration = $travelDuration;

        return $this;
    }

    /**
     * @return int
     */
    public function getAverageFlightDuration()
    {
        return $this->averageFlightDuration;
    }

    /**
     * @param int $averageFlightDuration
     *
     * @return Offer
     */
    public function setAverageFlightDuration($averageFlightDuration)
    {
        $this->averageFlightDuration = $averageFlightDuration;

        return $this;
    }

    /**
     * @return bool
     */
    public function isAlternative()
    {
        return $this->alternative;
    }

    /**
     * @param bool $alternative
     *
     * @return Offer
     */
    public function setAlternative($alternative)
    {
        $this->alternative = $alternative;

        return $this;
    }

    /**
     * @return bool
     */
    public function isExclusive()
    {
        return $this->exclusive;
    }

    /**
     * @param bool $exclusive
     *
     * @return Offer
     */
    public function setExclusive($exclusive)
    {
        $this->exclusive = $exclusive;

        return $this;
    }

    /**
     * @return TourOperator
     */
    public function getTourOperator()
    {
        return $this->tourOperator;
    }

    /**
     * @param TourOperator $tourOperator
     *
     * @return Offer
     */
    public function setTourOperator($tourOperator)
    {
        $this->tourOperator = $tourOperator;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDepartureDate()
    {
        return $this->departureDate;
    }

    /**
     * @param \DateTime $departureDate
     *
     * @return Offer
     */
    public function setDepartureDate($departureDate)
    {
        $this->departureDate = $departureDate;

        return $this;
    }

    /**
     * @return string
     */
    public function getSpecialJourneyAttributes()
    {
        return $this->specialJourneyAttributes;
    }

    /**
     * @param string $specialJourneyAttributes
     *
     * @return Offer
     */
    public function setSpecialJourneyAttributes($specialJourneyAttributes)
    {
        $this->specialJourneyAttributes = $specialJourneyAttributes;

        return $this;
    }

    /**
     * @return Package
     */
    public function getPackage()
    {
        return $this->package;
    }

    /**
     * @param Package $package
     *
     * @return Offer
     */
    public function setPackage($package)
    {
        $this->package = $package;

        return $this;
    }

    /**
     * @return string
     */
    public function getTravelType()
    {
        return $this->travelType;
    }

    /**
     * @param string $travelType
     *
     * @return Offer
     */
    public function setTravelType($travelType)
    {
        $this->travelType = $travelType;

        return $this;
    }

    /**
     * @return string
     */
    public function getProgramType()
    {
        return $this->programType;
    }

    /**
     * @param string $programType
     *
     * @return Offer
     */
    public function setProgramType($programType)
    {
        $this->programType = $programType;

        return $this;
    }

    /**
     * @return bool
     */
    public function isFlightBookedOut()
    {
        return $this->flightBookedOut;
    }

    /**
     * @param bool $flightBookedOut
     *
     * @return Offer
     */
    public function setFlightBookedOut($flightBookedOut)
    {
        $this->flightBookedOut = $flightBookedOut;

        return $this;
    }

    /**
     * @return bool
     */
    public function isAccommodationBookedOut()
    {
        return $this->AccommodationBookedOut;
    }

    /**
     * @param bool $AccommodationBookedOut
     *
     * @return Offer
     */
    public function setAccommodationBookedOut($AccommodationBookedOut)
    {
        $this->AccommodationBookedOut = $AccommodationBookedOut;

        return $this;
    }

    /**
     * @return array
     */
    public function getTourOperatorAttributes()
    {
        return $this->tourOperatorAttributes;
    }

    /**
     * @param array $tourOperatorAttributes
     *
     * @return Offer
     */
    public function setTourOperatorAttributes($tourOperatorAttributes)
    {
        $this->tourOperatorAttributes = $tourOperatorAttributes;

        return $this;
    }
}
