<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class Room
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class Room
{
    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Room")
     */
    private $room;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     */
    private $name;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Code")
     */
    private $code;

    /**
     * @var array
     * @Serializer\Type("array")
     * @Serializer\SerializedName("RoomAdditions")
     */
    private $roomAdditions;

    /**
     * Room constructor.
     *
     * @param string $room
     * @param string $name
     * @param int    $code
     * @param array  $roomAdditions
     */
    public function __construct($room, $name, $code, array $roomAdditions)
    {
        $this->room = $room;
        $this->name = $name;
        $this->code = $code;
        $this->roomAdditions = $roomAdditions;
    }

    /**
     * @return string
     */
    public function getRoom()
    {
        return $this->room;
    }

    /**
     * @param string $room
     *
     * @return Room
     */
    public function setRoom($room)
    {
        $this->room = $room;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return Room
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param int $code
     *
     * @return Room
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return array
     */
    public function getRoomAdditions()
    {
        return $this->roomAdditions;
    }

    /**
     * @param array $roomAdditions
     *
     * @return Room
     */
    public function setRoomAdditions($roomAdditions)
    {
        $this->roomAdditions = $roomAdditions;

        return $this;
    }
}
