<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest;

use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\TravelDateRequest\ExactTravelDateSpan;
use Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\TravelDateRequest\TravelDateSpan;
use Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\TravelDateRequest\TravelDurationSpan;

/**
 *
 * @Serializer\AccessType("public_method")
 */
class Journey
{

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("DepartureAirportCountry")
     */
    private $departureAirportCountry;

    /**
     * @var array<Traveller>
     * @Serializer\XmlList(entry = "Traveller")
     * @Serializer\SerializedName("TravellerList")
     */
    private $travellerList;


    /**
     * @var DepartureAirportList
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\DepartureAirportList")
     * @Serializer\SerializedName("DepartureAirportList")
     */
    private $departureAirportList;


    /**
     * @var TravelDateSpan
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\TravelDateRequest\TravelDateSpan")
     * @Serializer\SerializedName("TravelDateSpan")
     */
    private $travelDateSpan;

    /**
     * @var TravelDurationSpan
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\TravelDateRequest\TravelDurationSpan")
     * @Serializer\SerializedName("TravelDurationSpan")
     */
    private $travelDurationSpan;

    /**
     * @var ExactTravelDateSpan
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\TravelDateRequest\ExactTravelDateSpan")
     * @Serializer\SerializedName("ExactTravelDateSpan")
     */
    private $exactTravelDateSpan;

    /**
     * @var PriceSpan
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\PriceSpan")
     * @Serializer\SerializedName("PriceSpan")
     */
    private $priceSpan;

    /**
     * @var array<string>
     * @Serializer\XmlList(entry = "SpecialJourneyAttribute")
     * @Serializer\SerializedName("SpecialJourneyAttributes")
     */
    private $specialJourneyAttributes;


    private $spanishMarketScoped;


    /**
     * @return string
     */
    public function getDepartureAirportCountry()
    {
        return $this->departureAirportCountry;
    }

    /**
     * @param string $departureAirportCountry
     *
     * @return Journey
     */
    public function setDepartureAirportCountry($departureAirportCountry)
    {
        $this->departureAirportCountry = $departureAirportCountry;

        return $this;
    }

    /**
     * @return array
     */
    public function getTravellerList()
    {
        return $this->travellerList;
    }

    /**
     * @param array $travellerList
     *
     * @return Journey
     */
    public function setTravellerList($travellerList)
    {
        $this->travellerList = $travellerList;

        return $this;
    }

    /**
     * @return DepartureAirportList
     */
    public function getDepartureAirportList()
    {
        return $this->departureAirportList;
    }

    /**
     * @param DepartureAirportList $departureAirportList
     *
     * @return Journey
     */
    public function setDepartureAirportList($departureAirportList)
    {
        $this->departureAirportList = $departureAirportList;

        return $this;
    }

    /**
     * @return TravelDurationSpan
     */
    public function getTravelDurationSpan()
    {
        return $this->travelDurationSpan;
    }

    /**
     * @param TravelDurationSpan $travelDurationSpan
     *
     * @return Journey
     */
    public function setTravelDurationSpan($travelDurationSpan)
    {
        $this->travelDurationSpan = $travelDurationSpan;

        return $this;
    }

    /**
     * @return TravelDateSpan
     */
    public function getTravelDateSpan()
    {
        return $this->travelDateSpan;
    }

    /**
     * @param TravelDateSpan $travelDateSpan
     *
     * @return Journey
     */
    public function setTravelDateSpan($travelDateSpan)
    {
        $this->travelDateSpan = $travelDateSpan;

        return $this;
    }

    /**
     * @return ExactTravelDateSpan
     */
    public function getExactTravelDateSpan()
    {
        return $this->exactTravelDateSpan;
    }

    /**
     * @param ExactTravelDateSpan $exactTravelDateSpan
     *
     * @return Journey
     */
    public function setExactTravelDateSpan($exactTravelDateSpan)
    {
        $this->exactTravelDateSpan = $exactTravelDateSpan;

        return $this;
    }

    /**
     * @return PriceSpan
     */
    public function getPriceSpan()
    {
        return $this->priceSpan;
    }

    /**
     * @param PriceSpan $priceSpan
     *
     * @return Journey
     */
    public function setPriceSpan($priceSpan)
    {
        $this->priceSpan = $priceSpan;

        return $this;
    }

    /**
     * @return array
     */
    public function getSpecialJourneyAttributes()
    {
        return $this->specialJourneyAttributes;
    }

    /**
     * @param array $specialJourneyAttributes
     *
     * @return Journey
     */
    public function setSpecialJourneyAttributes($specialJourneyAttributes)
    {
        $this->specialJourneyAttributes = $specialJourneyAttributes;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getSpanishMarketScoped()
    {
        return $this->spanishMarketScoped;
    }

    /**
     * @param mixed $spanishMarketScoped
     *
     * @return Journey
     */
    public function setSpanishMarketScoped($spanishMarketScoped)
    {
        $this->spanishMarketScoped = $spanishMarketScoped;

        return $this;
    }
}
