<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class City
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class City
{
    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("City")
     */
    private $city;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("CityID")
     */
    private $cityId;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("HotelNumber")
     */
    private $hotelNumber;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("MinPrice")
     */
    private $minPrice;

    /**
     * @return string
     */
    public function getHotelNumber()
    {
        return $this->hotelNumber;
    }

    /**
     * @param string $hotelNumber
     *
     * @return City
     */
    public function setHotelNumber($hotelNumber)
    {
        $this->hotelNumber = $hotelNumber;

        return $this;
    }

    /**
     * @return float
     */
    public function getMinPrice()
    {
        return $this->minPrice;
    }

    /**
     * @param float $minPrice
     *
     * @return City
     */
    public function setMinPrice($minPrice)
    {
        $this->minPrice = $minPrice;

        return $this;
    }

    /**
     * City constructor.
     *
     * @param string $city
     * @param int    $cityId
     */
    public function __construct($city, $cityId)
    {
        $this->city = $city;
        $this->cityId = $cityId;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @param string $city
     *
     * @return City
     */
    public function setCity($city)
    {
        $this->city = $city;

        return $this;
    }

    /**
     * @return int
     */
    public function getCityId()
    {
        return $this->cityId;
    }

    /**
     * @param int $cityId
     *
     * @return City
     */
    public function setCityId($cityId)
    {
        $this->cityId = $cityId;

        return $this;
    }
}
