<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Header
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class Header
{
    /**
     * @var array
     * @Serializer\XmlList(entry = "Airport")
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\FlightResponse\Airport>")
     * @Serializer\SerializedName("DepartureAirports")
     */
    private $departureAirports;

    /**
     * @var  array<DateTime>
     * @Serializer\XmlList(entry = "Departure")
     * @Serializer\Type("array<DateTime <'Y-m-d'>>")
     * @Serializer\SerializedName("Departures")
     */
    private $departures;

    /**
     * /**
     * @var  array<int>
     * @Serializer\XmlList(entry = "Duration")
     * @Serializer\Type("array<int>")
     * @Serializer\SerializedName("Durations")
     */
    private $durations;

    /**
     * @var  array<Room>
     * @Serializer\XmlList(entry = "Room")
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\Room>")
     * @Serializer\SerializedName("Rooms")
     */
    private $rooms;

    /**
     * @var  array<string>
     * @Serializer\XmlList(entry = "Board")
     * @Serializer\Type("array<string>")
     * @Serializer\SerializedName("Boards")
     */
    private $boards;

    /**
     * @var  array<TourOperator>
     * @Serializer\XmlList(entry = "TourOperator")
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\TourOperator>")
     * @Serializer\SerializedName("TourOperators")
     */
    private $tourOperators;


    public function __construct($departureAirports, $departures, $durations, $rooms, $boards, $tourOperators)
    {
        $this->departureAirports = $departureAirports;
        $this->departures = $departures;
        $this->durations = $durations;
        $this->rooms = $rooms;
        $this->boards = $boards;
        $this->tourOperators = $tourOperators;
    }

    /**
     * @return array
     */
    public function getDepartureAirports()
    {
        return $this->departureAirports;
    }

    /**
     * @param array $departureAirports
     *
     * @return Header
     */
    public function setDepartureAirports($departureAirports)
    {
        $this->departureAirports = $departureAirports;

        return $this;
    }

    /**
     * @return array
     */
    public function getDepartures()
    {
        return $this->departures;
    }

    /**
     * @param array $departures
     *
     * @return Header
     */
    public function setDepartures($departures)
    {
        $this->departures = $departures;

        return $this;
    }

    /**
     * @return array
     */
    public function getDurations()
    {
        return $this->durations;
    }

    /**
     * @param array $durations
     *
     * @return Header
     */
    public function setDurations($durations)
    {
        $this->durations = $durations;

        return $this;
    }

    /**
     * @return array
     */
    public function getRooms()
    {
        return $this->rooms;
    }

    /**
     * @param array $rooms
     *
     * @return Header
     */
    public function setRooms($rooms)
    {
        $this->rooms = $rooms;

        return $this;
    }

    /**
     * @return array
     */
    public function getBoards()
    {
        return $this->boards;
    }

    /**
     * @param array $boards
     *
     * @return Header
     */
    public function setBoards($boards)
    {
        $this->boards = $boards;

        return $this;
    }

    /**
     * @return array
     */
    public function getTourOperators()
    {
        return $this->tourOperators;
    }

    /**
     * @param array $tourOperators
     *
     * @return Header
     */
    public function setTourOperators($tourOperators)
    {
        $this->tourOperators = $tourOperators;

        return $this;
    }
}
