<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

/**
 * Created by PhpStorm.
 * User: j.kretz
 * Date: 14.07.2017
 * Time: 12:03
 */

namespace Test\Vtours\TTXmlWebService;

use JMS\Serializer\Serializer;
use PHPUnit\Framework\TestCase;
use Vtours\TTXmlWebService\Model\Request\SearchEngineOfferListRQ;

class SearchEngineOfferListRQTest extends TestCase
{

    /**
     * @var Serializer
     */
    private $serializer;

    public function setUp()
    {
        $this->serializer = \JMS\Serializer\SerializerBuilder::create()->build();
    }

    public function testGetOfferList()
    {
        $this->markTestSkipped('skip offer city');
        $hotelId = 32394; //giata
        $mealType = null;
        $durationDays = [2, 5];
        $durationPeriod = [];
        $type = 'Package'; //change to 'Hotel' for offers without flight

        $request = new SearchEngineOfferListRQ($durationDays, $durationPeriod, $mealType, $hotelId);
        $request->setTimestamp(null);

        $output = <<<'TAG'
<?xml version="1.0" encoding="UTF-8"?>
<t:SearchEngineOfferListRQ xmlns:t="http://traveltainment.de/middleware/xml/SearchEngineOfferListRQ" Target="Test" LanguageCode="de-DE" TrackingID="22" ClientSessionID="11" ClientIP="111.222.333.44">
  <CID><![CDATA[12345678]]></CID>
  <Search>
    <Trip>
      <Journey>
        <DepartureAirportCountry><![CDATA[DE]]></DepartureAirportCountry>
        <TravellerList>
          <Traveller Age="30"/>
        </TravellerList>
        <TravelDurationSpan>
          <MinDays>2</MinDays>
          <MaxDays>5</MaxDays>
        </TravelDurationSpan>
      </Journey>
      <Hotel/>
      <TourOperator/>
    </Trip>
    <Options>
      <ResultsPerPage>10</ResultsPerPage>
      <ResultOffset>0</ResultOffset>
      <AdditionalCurrencies><![CDATA[EUR]]></AdditionalCurrencies>
      <Sorting><![CDATA[PRICE]]></Sorting>
    </Options>
  </Search>
  <Selection>
    <HotelSelection>
      <ObjectID Type="Giata">32394</ObjectID>
    </HotelSelection>
  </Selection>
</t:SearchEngineOfferListRQ>

TAG;
//        var_dump($request);
        $xml = $this->serializer->serialize($request, 'xml');
        $this->assertEquals($output, $xml);

    }
}