<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest;

use JMS\Serializer\Annotation as Serializer;

class RoomType
{

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Room")
     */
    private $room;

    /**
     * @var int
     * @Serializer\XmlAttribute()
     * @Serializer\SerializedName("Weightage")
     */
    private $weightage;

    /**
     * @var array<string>
     * @Serializer\XmlList(entry = "RoomAddition")
     * @Serializer\SerializedName("RoomAdditions")
     */
    private $roomAdditions;



    /**
     * @return string
     */
    public function getRoom()
    {
        return $this->room;
    }

    /**
     * @param string $room
     *
     * @return RoomType
     */
    public function setRoom($room)
    {
        $this->room = $room;

        return $this;
    }

    /**
     * @return array
     */
    public function getRoomAdditions()
    {
        return $this->roomAdditions;
    }

    /**
     * @param array $roomAdditions
     *
     * @return RoomType
     */
    public function setRoomAdditions($roomAdditions)
    {
        $this->roomAdditions = $roomAdditions;

        return $this;
    }

    /**
     * @return int
     */
    public function getWeightage()
    {
        return $this->weightage;
    }

    /**
     * @param int $weightage
     *
     * @return RoomType
     */
    public function setWeightage($weightage)
    {
        $this->weightage = $weightage;

        return $this;
    }
}
