<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Accommodation
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class Accommodation
{
    /**
     * @var Room
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\Room")
     * @Serializer\SerializedName("Room")
     */
    private $room;

    /**
     * @var Meal
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\Meal")
     * @Serializer\SerializedName("Meal")
     */
    private $meal;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("AccomCode")
     */
    private $accomCode;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("Category")
     */
    private $category;

    /**
     * @var bool
     * @Serializer\Type("isRefundable")
     * @Serializer\SerializedName("IsRefundable")
     */
    private $isRefundable;

    /**
     * @var array<string>
     * @Serializer\XmlList(entry ="RoomAddition")
     * @Serializer\Type("array<string>")
     * @Serializer\SerializedName("RoomAdditions")
     */
    private $roomAdditions;

    /**
     * Accommodation constructor.
     *
     * @param Room  $room
     * @param array $meal
     * @param int   $accomCode
     * @param int   $category
     * @param bool  $isRefundable
     * @param array $roomAdditions
     */
    public function __construct(Room $room, array $meal, $accomCode, $category, $isRefundable, array $roomAdditions)
    {
        $this->room = $room;
        $this->meal = $meal;
        $this->accomCode = $accomCode;
        $this->category = $category;
        $this->isRefundable = $isRefundable;
        $this->roomAdditions = $roomAdditions;
    }

    /**
     * @return Room
     */
    public function getRoom()
    {
        return $this->room;
    }

    /**
     * @param Room $room
     *
     * @return Accommodation
     */
    public function setRoom($room)
    {
        $this->room = $room;

        return $this;
    }

    /**
     * @return array
     */
    public function getMeal()
    {
        return $this->meal;
    }

    /**
     * @param array $meal
     *
     * @return Accommodation
     */
    public function setMeal($meal)
    {
        $this->meal = $meal;

        return $this;
    }

    /**
     * @return int
     */
    public function getAccomCode()
    {
        return $this->accomCode;
    }

    /**
     * @param int $accomCode
     *
     * @return Accommodation
     */
    public function setAccomCode($accomCode)
    {
        $this->accomCode = $accomCode;

        return $this;
    }

    /**
     * @return int
     */
    public function getCategory()
    {
        return $this->category;
    }

    /**
     * @param int $category
     *
     * @return Accommodation
     */
    public function setCategory($category)
    {
        $this->category = $category;

        return $this;
    }

    /**
     * @return bool
     */
    public function isRefundable()
    {
        return $this->isRefundable;
    }

    /**
     * @param bool $isRefundable
     *
     * @return Accommodation
     */
    public function setIsRefundable($isRefundable)
    {
        $this->isRefundable = $isRefundable;

        return $this;
    }

    /**
     * @return array
     */
    public function getRoomAdditions()
    {
        return $this->roomAdditions;
    }

    /**
     * @param array $roomAdditions
     *
     * @return Accommodation
     */
    public function setRoomAdditions($roomAdditions)
    {
        $this->roomAdditions = $roomAdditions;

        return $this;
    }
}
