<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class HotelReview
 *
 * @package Vtours\TTXmlWebService\Model\Response
 * @Serializer\XmlRoot("hotelReview")
 */
class HotelReview
{
    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("NumberOfRatings")
     */
    private $numberOfRatings;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("Recommendation")
     */
    private $recommendation;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingOverAll")
     */
    private $ratingOverAll;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingEatAndDrink")
     */
    private $ratingEatAndDrink;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingFamily")
     */
    private $ratingFamily;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingHotel")
     */
    private $ratingHotel;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingLocation")
     */
    private $ratingLocation;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingPool")
     */
    private $ratingPool;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingService")
     */
    private $ratingService;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingSport")
     */
    private $ratingSport;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingBeach")
     */
    private $ratingBeach;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingRoom")
     */
    private $ratingRoom;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingCulture")
     */
    private $ratingCulture;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingInfrastructure")
     */
    private $ratingInfrastructure;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingActivities")
     */
    private $ratingActivities;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingSkiArea")
     */
    private $ratingSkiArea;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingWinterSportOffer")
     */
    private $ratingWinterSportOffer;

    /**
     * @var double
     * @Serializer\Type("double")
     * @Serializer\SerializedName("RatingWellness")
     */
    private $ratingWellness;

    /**
     * @return int
     */
    public function getNumberOfRatings()
    {
        return $this->numberOfRatings;
    }

    /**
     * @param int $numberOfRatings
     *
     * @return HotelReview
     */
    public function setNumberOfRatings($numberOfRatings)
    {
        $this->numberOfRatings = $numberOfRatings;

        return $this;
    }

    /**
     * @return float
     */
    public function getRecommendation()
    {
        return $this->recommendation;
    }

    /**
     * @param float $recommendation
     *
     * @return HotelReview
     */
    public function setRecommendation($recommendation)
    {
        $this->recommendation = $recommendation;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingOverAll()
    {
        return $this->ratingOverAll;
    }

    /**
     * @param float $ratingOverAll
     *
     * @return HotelReview
     */
    public function setRatingOverAll($ratingOverAll)
    {
        $this->ratingOverAll = $ratingOverAll;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingEatAndDrink()
    {
        return $this->ratingEatAndDrink;
    }

    /**
     * @param float $ratingEatAndDrink
     *
     * @return HotelReview
     */
    public function setRatingEatAndDrink($ratingEatAndDrink)
    {
        $this->ratingEatAndDrink = $ratingEatAndDrink;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingFamily()
    {
        return $this->ratingFamily;
    }

    /**
     * @param float $ratingFamily
     *
     * @return HotelReview
     */
    public function setRatingFamily($ratingFamily)
    {
        $this->ratingFamily = $ratingFamily;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingHotel()
    {
        return $this->ratingHotel;
    }

    /**
     * @param float $ratingHotel
     *
     * @return HotelReview
     */
    public function setRatingHotel($ratingHotel)
    {
        $this->ratingHotel = $ratingHotel;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingLocation()
    {
        return $this->ratingLocation;
    }

    /**
     * @param float $ratingLocation
     *
     * @return HotelReview
     */
    public function setRatingLocation($ratingLocation)
    {
        $this->ratingLocation = $ratingLocation;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingPool()
    {
        return $this->ratingPool;
    }

    /**
     * @param float $ratingPool
     *
     * @return HotelReview
     */
    public function setRatingPool($ratingPool)
    {
        $this->ratingPool = $ratingPool;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingService()
    {
        return $this->ratingService;
    }

    /**
     * @param float $ratingService
     *
     * @return HotelReview
     */
    public function setRatingService($ratingService)
    {
        $this->ratingService = $ratingService;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingSport()
    {
        return $this->ratingSport;
    }

    /**
     * @param float $ratingSport
     *
     * @return HotelReview
     */
    public function setRatingSport($ratingSport)
    {
        $this->ratingSport = $ratingSport;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingBeach()
    {
        return $this->ratingBeach;
    }

    /**
     * @param float $ratingBeach
     *
     * @return HotelReview
     */
    public function setRatingBeach($ratingBeach)
    {
        $this->ratingBeach = $ratingBeach;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingRoom()
    {
        return $this->ratingRoom;
    }

    /**
     * @param float $ratingRoom
     *
     * @return HotelReview
     */
    public function setRatingRoom($ratingRoom)
    {
        $this->ratingRoom = $ratingRoom;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingCulture()
    {
        return $this->ratingCulture;
    }

    /**
     * @param float $ratingCulture
     *
     * @return HotelReview
     */
    public function setRatingCulture($ratingCulture)
    {
        $this->ratingCulture = $ratingCulture;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingInfrastructure()
    {
        return $this->ratingInfrastructure;
    }

    /**
     * @param float $ratingInfrastructure
     *
     * @return HotelReview
     */
    public function setRatingInfrastructure($ratingInfrastructure)
    {
        $this->ratingInfrastructure = $ratingInfrastructure;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingActivities()
    {
        return $this->ratingActivities;
    }

    /**
     * @param float $ratingActivities
     *
     * @return HotelReview
     */
    public function setRatingActivities($ratingActivities)
    {
        $this->ratingActivities = $ratingActivities;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingSkiArea()
    {
        return $this->ratingSkiArea;
    }

    /**
     * @param float $ratingSkiArea
     *
     * @return HotelReview
     */
    public function setRatingSkiArea($ratingSkiArea)
    {
        $this->ratingSkiArea = $ratingSkiArea;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingWinterSportOffer()
    {
        return $this->ratingWinterSportOffer;
    }

    /**
     * @param float $ratingWinterSportOffer
     *
     * @return HotelReview
     */
    public function setRatingWinterSportOffer($ratingWinterSportOffer)
    {
        $this->ratingWinterSportOffer = $ratingWinterSportOffer;

        return $this;
    }

    /**
     * @return float
     */
    public function getRatingWellness()
    {
        return $this->ratingWellness;
    }

    /**
     * @param float $ratingWellness
     *
     * @return HotelReview
     */
    public function setRatingWellness($ratingWellness)
    {
        $this->ratingWellness = $ratingWellness;

        return $this;
    }
}
