<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

use JMS\Serializer\Serializer;

/**
 * Created by PhpStorm.
 * User: j.kretz
 * Date: 04.07.2017
 * Time: 13:41
 */

/**
 * Class HotelTest
 */
class HotelTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var Serializer
     */
    private $serializer;

    public function setUp()
    {
        $this->serializer = \JMS\Serializer\SerializerBuilder::create()->build();

    }


    public function testHotel()
    {

        $this->markTestSkipped('skip hotel');

        $input = <<<'TAG'
<?xml version="1.0" encoding="UTF-8"?>
<Hotel>
  <ObjectName><![CDATA[Blubberhotel]]></ObjectName>
  <ObjectID>123</ObjectID>
  <City>
    <City><![CDATA[Blubberhausen]]></City>
    <CityID>112233</CityID>
  </City>
  <Category>
    <Stars>5</Stars>
    <MinStars>4.0</MinStars>
    <MaxStars>5.0</MaxStars>
  </Category>
  <HotelReview>
    <NumberOfRatings>900000</NumberOfRatings>
    <Recommendation>8.0</Recommendation>
    <RatingOverAll>8.5</RatingOverAll>
    <RatingEatAndDrink>10.0</RatingEatAndDrink>
    <RatingFamily>4.0</RatingFamily>
    <RatingHotel>8.0</RatingHotel>
    <RatingLocation>10.0</RatingLocation>
    <RatingPool>9.5</RatingPool>
    <RatingService>8.9</RatingService>
    <RatingBeach>7.5</RatingBeach>
    <RatingRoom>9.5</RatingRoom>
    <RatingWellness>10.0</RatingWellness>
  </HotelReview>
  <HotelAttributes>
    <HotelAttribute><![CDATA[Spabereich]]></HotelAttribute>
    <HotelAttribute><![CDATA[Saunalandschaft]]></HotelAttribute>
  </HotelAttributes>
  <TeaserText><![CDATA[Entspannungsurlaub!]]></TeaserText>
  <AccomIds>
    <Id>12345</Id>
    <Id>54321</Id>
  </AccomIds>
</Hotel>

TAG;

        $hotel = new \Vtours\TTXmlWebService\Model\Response\Hotel();
        $hotel = $hotel->setObjectName('Blubberhotel')
            ->setObjectId(123)
            ->setCity(new \Vtours\TTXmlWebService\Model\Response\City('Blubberhausen', 112233))
            ->setCategory(new \Vtours\TTXmlWebService\Model\Response\Category(5, 4.0, 5.0))
            ->setHotelReview(new \Vtours\TTXmlWebService\Model\Response\HotelReview(900000, 8.0, 8.5, 10.0, 4.0, 8.0, 10.0, 9.5, 8.9, null, 7.5, 9.5,
                null, null, null, null, null, 10.0))
            ->setHotelAttributes(['Spabereich', 'Saunalandschaft'])
            ->setTeaserText('Entspannungsurlaub!')
            ->setAccomIds([12345, 54321]);

        /**
         * @var \Vtours\TTXmlWebService\Model\Response\Hotel §input
         */
        $input2 = $this->serializer->deserialize($input, Vtours\TTXmlWebService\Model\Response\Hotel::class, 'xml');
        var_dump($input2);
        //var_dump($hotel);
        $this->assertEquals($hotel, $input2);
//        $hotel = $this->serializer->serialize($hotel, 'xml');
//        $this->assertEquals($input, $hotel);


    }
}