<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model;

class DatenAngebotRequestModel
{
    /**
     * @var int $code
     */
    private $code;
    /**
     * @var string $codetype
     */
    private $codetype;
    /**
     * @var string $offertype
     */
    private $offertype;
    /**
     * @var int $priceMin
     */
    private $priceMin;
    /**
     * @var int $priceMax
     */
    private $priceMax;
    /**
     * @var /Datetime $traveldateStart
     */
    private $traveldateStart;
    /**
     * @var /Datetime $traveldateEnd
     */
    private $traveldateEnd;
    /**
     * @var int $traveldurationMin
     */
    private $traveldurationMin;
    /**
     * @var int $traveldurationMax
     */
    private $traveldurationMax;
    /**
     * @var string $departureAirport
     */
    private $departureAirport;
    /**
     * @var string $mealtype
     */
    private $mealtype;
    /**
     * @var string $roomtype
     */
    private $roomtype;
    /**
     * @var array $specialJourneyAttributes
     */
    private $specialJourneyAttributes;
    /**
     * @var array $hotelAttributes
     */
    private $hotelAttributes;
    /**
     * @var string $brand
     */
    private $brand;
    /**
     * @var array $travellers
     */
    private $travellers;

    /**
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param int $code
     *
     * @return DatenAngebotRequestModel
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return string
     */
    public function getCodetype()
    {
        return $this->codetype;
    }

    /**
     * @param string $codetype
     *
     * @return DatenAngebotRequestModel
     */
    public function setCodetype($codetype)
    {
        $this->codetype = $codetype;

        return $this;
    }

    /**
     * @return string
     */
    public function getOffertype()
    {
        return $this->offertype;
    }

    /**
     * @param string $offertype
     *
     * @return DatenAngebotRequestModel
     */
    public function setOffertype($offertype)
    {
        $this->offertype = $offertype;

        return $this;
    }

    /**
     * @return int
     */
    public function getPriceMin()
    {
        return $this->priceMin;
    }

    /**
     * @param int $priceMin
     *
     * @return DatenAngebotRequestModel
     */
    public function setPriceMin($priceMin)
    {
        $this->priceMin = $priceMin;

        return $this;
    }

    /**
     * @return int
     */
    public function getPriceMax()
    {
        return $this->priceMax;
    }

    /**
     * @param int $priceMax
     *
     * @return DatenAngebotRequestModel
     */
    public function setPriceMax($priceMax)
    {
        $this->priceMax = $priceMax;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getTraveldateStart()
    {
        return $this->traveldateStart;
    }

    /**
     * @param mixed $traveldateStart
     *
     * @return DatenAngebotRequestModel
     */
    public function setTraveldateStart($traveldateStart)
    {
        $this->traveldateStart = $traveldateStart;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getTraveldateEnd()
    {
        return $this->traveldateEnd;
    }

    /**
     * @param mixed $traveldateEnd
     *
     * @return DatenAngebotRequestModel
     */
    public function setTraveldateEnd($traveldateEnd)
    {
        $this->traveldateEnd = $traveldateEnd;

        return $this;
    }

    /**
     * @return int
     */
    public function getTraveldurationMin()
    {
        return $this->traveldurationMin;
    }

    /**
     * @param int $traveldurationMin
     *
     * @return DatenAngebotRequestModel
     */
    public function setTraveldurationMin($traveldurationMin)
    {
        $this->traveldurationMin = $traveldurationMin;

        return $this;
    }

    /**
     * @return int
     */
    public function getTraveldurationMax()
    {
        return $this->traveldurationMax;
    }

    /**
     * @param int $traveldurationMax
     *
     * @return DatenAngebotRequestModel
     */
    public function setTraveldurationMax($traveldurationMax)
    {
        $this->traveldurationMax = $traveldurationMax;

        return $this;
    }

    /**
     * @return string
     */
    public function getDepartureAirport()
    {
        return $this->departureAirport;
    }

    /**
     * @param string $departureAirport
     *
     * @return DatenAngebotRequestModel
     */
    public function setDepartureAirport($departureAirport)
    {
        $this->departureAirport = $departureAirport;

        return $this;
    }

    /**
     * @return string
     */
    public function getMealtype()
    {
        return $this->mealtype;
    }

    /**
     * @param string $mealtype
     *
     * @return DatenAngebotRequestModel
     */
    public function setMealtype($mealtype)
    {
        $this->mealtype = $mealtype;

        return $this;
    }

    /**
     * @return string
     */
    public function getRoomtype()
    {
        return $this->roomtype;
    }

    /**
     * @param string $roomtype
     *
     * @return DatenAngebotRequestModel
     */
    public function setRoomtype($roomtype)
    {
        $this->roomtype = $roomtype;

        return $this;
    }

    /**
     * @return array
     */
    public function getSpecialJourneyAttributes()
    {
        return $this->specialJourneyAttributes;
    }

    /**
     * @param array $specialJourneyAttributes
     *
     * @return DatenAngebotRequestModel
     */
    public function setSpecialJourneyAttributes($specialJourneyAttributes)
    {
        $this->specialJourneyAttributes = $specialJourneyAttributes;

        return $this;
    }

    /**
     * @return array
     */
    public function getHotelAttributes()
    {
        return $this->hotelAttributes;
    }

    /**
     * @param array $hotelAttributes
     *
     * @return DatenAngebotRequestModel
     */
    public function setHotelAttributes($hotelAttributes)
    {
        $this->hotelAttributes = $hotelAttributes;

        return $this;
    }

    /**
     * @return string
     */
    public function getBrand()
    {
        return $this->brand;
    }

    /**
     * @param string $brand
     *
     * @return DatenAngebotRequestModel
     */
    public function setBrand($brand)
    {
        $this->brand = $brand;

        return $this;
    }

    /**
     * @return array
     */
    public function getTravellers()
    {
        return $this->travellers;
    }

    /**
     * @param array $travellers
     *
     * @return DatenAngebotRequestModel
     */
    public function setTravellers($travellers)
    {
        $this->travellers = $travellers;

        return $this;
    }
}
