<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Meal
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class Meal
{
    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Meal")
     */
    private $meal;

    /**
     * @return string
     */
    public function getMeal()
    {
        return $this->meal;
    }

    /**
     * @param string $meal
     *
     * @return Meal
     */
    public function setMeal($meal)
    {
        $this->meal = $meal;

        return $this;
    }
}
