<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Vtours\TTXmlWebService\Helper;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use JMS\Serializer\SerializerBuilder;
use JMS\Serializer\SerializerInterface;

/**
 * Class Factory
 * @package Vtours\TTXmlWebService\Helper
 */
class Factory
{
    const GUZZLE_BASE_URI = 'http://de-ttxml.traveltainment.eu/TTXml-1.7/';

    /**
     * @var array
     */
    private $facSetter = [];

    /**
     * @return ClientInterface
     */
    public function client()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] =  new Client(['base_uri' => self::GUZZLE_BASE_URI]);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return SerializerInterface
     */
    public function serializer()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] =  SerializerBuilder::create()->build();
        }
        return $this->facSetter[__FUNCTION__];
    }
}
