<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Hotel
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class Hotel
{
    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("HotelType")
     */
    private $hotelType;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ObjectName")
     */
    private $objectName;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("ObjectID")
     */
    private $objectId;

    /**
     * @var City
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\City")
     * @Serializer\SerializedName("City")
     */
    private $city;

    /**
     * @var Category
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\Category")
     * @Serializer\SerializedName("Category")
     */
    private $category;

    /**
     * @var HotelReview
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\HotelReview")
     * @Serializer\SerializedName("HotelReview")
     */
    private $hotelReview;

    /**
     * @var ObjectImages
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\ObjectImages")
     * @Serializer\SerializedName("ObjectImages")
     */
    private $objectImages;

    /**
     * @var array<string>
     * @Serializer\Type("array<string>")
     * @Serializer\XmlList(entry = "HotelAttribute")
     * @Serializer\SerializedName("HotelAttributes")
     */
    private $hotelAttributes;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TeaserText")
     */
    private $teaserText;

    /**
     * @var array<int>
     * @Serializer\Type("array<int>")
     * @Serializer\XmlList(entry="Id")
     * @Serializer\SerializedName("AccomIds")
     */
    private $accomIds;

    /**
     * @return string
     */
    public function getHotelType()
    {
        return $this->hotelType;
    }

    /**
     * @param string $hotelType
     *
     * @return Hotel
     */
    public function setHotelType($hotelType)
    {
        $this->hotelType = $hotelType;

        return $this;
    }

    /**
     * @return string
     */
    public function getObjectName()
    {
        return $this->objectName;
    }

    /**
     * @param string $objectName
     *
     * @return Hotel
     */
    public function setObjectName($objectName)
    {
        $this->objectName = $objectName;

        return $this;
    }

    /**
     * @return int
     */
    public function getObjectId()
    {
        return $this->objectId;
    }

    /**
     * @param int $objectId
     *
     * @return Hotel
     */
    public function setObjectId($objectId)
    {
        $this->objectId = $objectId;

        return $this;
    }

    /**
     * @return City
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @param City $city
     *
     * @return Hotel
     */
    public function setCity($city)
    {
        $this->city = $city;

        return $this;
    }

    /**
     * @return Category
     */
    public function getCategory()
    {
        return $this->category;
    }

    /**
     * @param Category $category
     *
     * @return Hotel
     */
    public function setCategory($category)
    {
        $this->category = $category;

        return $this;
    }

    /**
     * @return HotelReview
     */
    public function getHotelReview()
    {
        return $this->hotelReview;
    }

    /**
     * @param HotelReview $hotelReview
     *
     * @return Hotel
     */
    public function setHotelReview($hotelReview)
    {
        $this->hotelReview = $hotelReview;

        return $this;
    }

    /**
     * @return ObjectImages
     */
    public function getObjectImages()
    {
        return $this->objectImages;
    }

    /**
     * @param ObjectImages $objectImages
     *
     * @return Hotel
     */
    public function setObjectImages($objectImages)
    {
        $this->objectImages = $objectImages;

        return $this;
    }

    /**
     * @return array
     */
    public function getHotelAttributes()
    {
        return $this->hotelAttributes;
    }

    /**
     * @param array $hotelAttributes
     *
     * @return Hotel
     */
    public function setHotelAttributes($hotelAttributes)
    {
        $this->hotelAttributes = $hotelAttributes;

        return $this;
    }

    /**
     * @return string
     */
    public function getTeaserText()
    {
        return $this->teaserText;
    }

    /**
     * @param string $teaserText
     *
     * @return Hotel
     */
    public function setTeaserText($teaserText)
    {
        $this->teaserText = $teaserText;

        return $this;
    }

    /**
     * @return array
     */
    public function getAccomIds()
    {
        return $this->accomIds;
    }

    /**
     * @param array $accomIds
     *
     * @return Hotel
     */
    public function setAccomIds($accomIds)
    {
        $this->accomIds = $accomIds;

        return $this;
    }
}
