<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Vtours\TTXmlWebService\Service\OfferList;

use Vtours\TTXmlWebService\Model\DatenAngebotRequestModel;
use Vtours\TTXmlWebService\Model\Request\SearchEngineOfferListRQ;
use Vtours\TTXmlWebService\Model\Request\SelectionRequest\HotelSelection;
use Vtours\TTXmlWebService\Model\Request\SelectionRequest\ObjectId;
use Vtours\TTXmlWebService\Model\Request\SelectionRequest\Selection;
use Vtours\TTXmlWebService\Service\MappingHelper\GeneralMappingHelper;

/**
 * Class Mapper
 *
 * @package Vtours\TTXmlWebService\Service\OfferList
 */
class Mapper
{
    /**
     * @var GeneralMappingHelper $generalMappingHelper
     */
    private $generalMappingHelper;

    public function __construct(GeneralMappingHelper $generalMappingHelper)
    {
        $this->generalMappingHelper = $generalMappingHelper;
    }

    /**
     * @param DatenAngebotRequestModel $request
     *
     * @return SearchEngineOfferListRQ
     */
    public function mapRequestByHotelCode(DatenAngebotRequestModel $request)
    {
        $search = $this->generalMappingHelper->mapSearchEngineRequest($request);

        $selection = new Selection();
        $hotelSelection = new HotelSelection();
        $objectIds = new ObjectId();
        $codeType = $request->getCodeType();
        $code = $request->getCode();

        $objectIds = $objectIds
            ->setType($codeType)
            ->setValue($code);
        $hotelSelection = $hotelSelection->setObjectId($objectIds);
        $selection = $selection->setHotelSelection($hotelSelection);

        $searchEngineOfferListRQ = new SearchEngineOfferListRQ();
        return $searchEngineOfferListRQ
            ->setSelection($selection)
            ->setSearch($search);
    }
}
