<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

/**
 * Created by PhpStorm.
 * User: j.kretz
 * Date: 29.06.2017
 * Time: 14:14
 */

namespace Test\Vtours\TTXmlWebService;

use JMS\Serializer\Serializer;
use PHPUnit\Framework\TestCase;
use Vtours\TTXmlWebService\Model\Request\Journey;

class JourneyTest extends TestCase
{
    /**
     * @var Serializer
     */
    private $serializer;

    public function setUp()
    {
        $this->serializer = \JMS\Serializer\SerializerBuilder::create()->build();

    }

    public function testJourney()
    {
        $this->markTestSkipped('skip journey');

        $journey = new Journey();
        $output = <<<'TAG'
<?xml version="1.0" encoding="UTF-8"?>
<journey>
  <DepartureAirportCountry><![CDATA[DE]]></DepartureAirportCountry>
  <DepartureAirportList>
    <Airport><![CDATA[ABC]]></Airport>
    <Airport><![CDATA[DEF]]></Airport>
    <Airport><![CDATA[GHI]]></Airport>
  </DepartureAirportList>
  <SpecialJourneyAttributes>
    <SpecialJourneyAttribute><![CDATA[EARLYBIRD]]></SpecialJourneyAttribute>
    <SpecialJourneyAttribute><![CDATA[RAILANDFLY]]></SpecialJourneyAttribute>
    <SpecialJourneyAttribute><![CDATA[RENTALCAR]]></SpecialJourneyAttribute>
    <SpecialJourneyAttribute><![CDATA[TRANSFER]]></SpecialJourneyAttribute>
  </SpecialJourneyAttributes>
</journey>

TAG;


        $journey = $this->serializer->serialize($journey, 'xml');
        $this->assertEquals($output, $journey);
    }
}