<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Vtours\TTXmlWebService\Service\HotelList;

use GuzzleHttp\ClientInterface;
use JMS\Serializer\SerializerInterface;
use PHPUnit\Framework\TestCase;
use Vtours\TTXmlWebService\Service\HotelList\Handler;
use Vtours\TTXmlWebService\Service\HotelList\Mapper;
use Vtours\TTXmlWebService\Service\MappingHelper\GeneralMappingHelper;

/**
 * Class HandlerTest
 *
 * @package Tests\Vtours\TTXmlWebService\Service\HotelList
 */
class HotelListHandlerTest extends TestCase
{
    /**
     * creating and mapping of requestmodel by given data-array
     * remove all timestamp-based attributes and compare to given serialized request
     */
    public function testCreateRequestXml()
    {
        $mapper = new Mapper();
        $generalMappingHelper = new GeneralMappingHelper();

        $serializer = $this->getMockBuilder(SerializerInterface::class)->getMock();
        $serializer = \JMS\Serializer\SerializerBuilder::create()->build();

        $client = $this->getMockBuilder(ClientInterface::class)->getMock();

        $serviceHandler = new Handler($mapper, $serializer, $client, $generalMappingHelper);

        $class = new \ReflectionClass(Handler::class);
        $method = $class->getMethod('createRequestXml');
        $method->setAccessible(true);
        $requestData = include __DIR__ . '/TopRegionIdRequestData.php';

        $requestXml = $method->invoke($serviceHandler, $requestData);
        $removeString = [
            '/<TravelDateSpan>/',
            '/<\/TravelDateSpan>/i',
            '/\s<DepartureDate>(.*?)<\/DepartureDate>\s/i',
            '/\s<ReturnDate>(.*?)<\/ReturnDate>\s/i',
            '/timestamp=\"(.*?)\"/i'
        ];
        $response = preg_replace($removeString, '', $requestXml);
        $this->assertXmlStringEqualsXmlString(file_get_contents(__DIR__ . '\SearchEngineHotelListRequest.xml'), $response);
    }

    public function testSuccesfulRequest()
    {

//        $mapper = $this->getMockBuilder(HotelMapper::class)->getMock();
//        $offerListMapper = $this->getMockBuilder(OfferMapper::class)->getMock();
//        $regionTreeMapper = $this->getMockBuilder(RegionTreeMapper::class)->getMock();
//        $serializer = $this->getMockBuilder(SerializerInterface::class)->getMock();
//
//        // Create a mock and queue the responses.
//        $mock = new MockHandler([
//            new Response(200, [], include __DIR__ . '/SearchEngineHotelListResponse.xml'),
//        ]);
//
//        $handler = HandlerStack::create($mock);
//        $client = new Client(['handler' => $handler]);
////        $generalMappingHelper = $this->getMockBuilder(GeneralMappingHelper::class)->getMock();
//        $generalMappingHelper = new GeneralMappingHelper();
//
//        $hotelListHandler = new Handler($mapper, $serializer, $client, $generalMappingHelper);
//        $offerListHandler = new \Vtours\TTXmlWebService\Service\OfferList\Handler($offerListMapper, $serializer, $client, $generalMappingHelper);
//        $regionTreeHandler = new \Vtours\TTXmlWebService\Service\RegionTree\Handler($regionTreeMapper, $serializer, $client, $generalMappingHelper);
//
//        $serviceFactory = new Factory($hotelListHandler, $offerListHandler, $regionTreeHandler);
//        $request = include __DIR__ . '/TopRegionIdRequestData.php';
//        $responseModel = $serviceFactory->hotelList()->getBestOffersByRegion($request);
//
//        $this->assertInstanceOf(SearchEngineHotelListRS::class, $responseModel);
//        // More response model assertions here ...
    }

    public function testRequestWillThrowException()
    {
        //$this->getExpectedException()

        // Mock guzzle to throw exception
//        $mock = new MockHandler([
//            new ClientException("", $this->getMockBuilder(RequestInterface::class)->getMock(), new Response(500)),
//        ]);
    }

    public function testBuildUri()
    {
        $mapper = $this->getMockBuilder(Mapper::class)->getMock();
        $serializer = $this->getMockBuilder(SerializerInterface::class)->getMock();
        $client = $this->getMockBuilder(ClientInterface::class)->getMock();
        $generalMappingHelper = $this->getMockBuilder(GeneralMappingHelper::class)->getMock();

        $serviceHandler = new Handler($mapper, $serializer, $client, $generalMappingHelper);

        $class = new \ReflectionClass(Handler::class);
        $method = $class->getMethod('buildUriFromRequest');
        $method->setAccessible(true);

        $uri = $method->invoke($serviceHandler, ['offertype' => 'test']);
        $this->assertSame('/Dispatcher/Search/test/HotelList', $uri);
    }

//    public function testTTWorking()
//    {
//        $mapper = new Mapper();
//        $generalMappingHelper = new GeneralMappingHelper();
//
//        $serializer = \JMS\Serializer\SerializerBuilder::create()->build();
//
//        $factory = new \Vtours\TTXmlWebService\Helper\Factory();
//        $client = $factory->client();
//        $request = include __DIR__ . '/TopRegionIdRequestData.php';
//
//        $serviceHandler = new Handler($mapper, $serializer, $client, $generalMappingHelper);
//
//        $responseModel = $serviceHandler->getBestOffersByRegion($request);
//        var_dump($responseModel);
//    }

}
