<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Vtours\TTXmlWebService\Service\HotelList;

use GuzzleHttp\ClientInterface;
use JMS\Serializer\SerializerInterface;
use Psr\Http\Message\ResponseInterface;
use Vtours\TTXmlWebService\Model\DatenAngebotRequestModel;
use Vtours\TTXmlWebService\Model\Response\SearchEngineHotelListRS;

/**
 * Class Handler
 *
 * @package Vtours\TTXmlWebService\Service\HotelList
 */
class Handler
{
    const API_URI = '/Dispatcher/Search/%s/HotelList';

    /**
     * @var Mapper
     */
    private $mapper;

    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ClientInterface
     */
    private $client;

    /**
     * Handler constructor.
     *
     * @param Mapper              $mapper
     * @param SerializerInterface $serializer
     * @param ClientInterface     $client
     */
    public function __construct(Mapper $mapper, SerializerInterface $serializer, ClientInterface $client)
    {
        $this->mapper = $mapper;
        $this->serializer = $serializer;
        $this->client = $client;
    }

    /**
     * @param DatenAngebotRequestModel $request
     *
     * @return array|\Exception|\JMS\Serializer\scalar|object
     */
    public function getBestOffersByRegion(DatenAngebotRequestModel $request)
    {
        $requestXml = $this->createRequestXml($request);

        $requestUri = $this->buildUriFromRequest($request);

        $requestOptions = [
            'headers' => [],
            'auth'    => ['MKT_655000_DE', '193893Hjtt0!aaaqq', 'digest'],
            'body'    => $requestXml,
        ];

        try {
            /** @var ResponseInterface $response */
            $response = $this->client->request('POST', $requestUri, $requestOptions);
            $result = $response->getBody()->getContents();

            return $this->serializer->deserialize($result, SearchEngineHotelListRS::class, 'xml');
        } catch (\Exception $exception) {
            // return false or null? or maybe do not catch exception in pimcore context?
            return $exception;
        }
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\DatenAngebotRequestModel $request
     *
     * @return string
     */
    private function createRequestXml(DatenAngebotRequestModel $request)
    {
        $requestModel = $this->mapper->mapRequestByRegion($request);

        return $this->serializer->serialize($requestModel, 'xml');
    }

    /**
     * @param $request
     *
     * @return string
     */
    private function buildUriFromRequest($request)
    {
        return sprintf(self::API_URI, $request->getOfferType());
    }
}
