<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Service\OfferList;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Handler\MockHandler;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Psr7\Response;
use JMS\Serializer\SerializerInterface;
use PHPUnit\Framework\TestCase;
use Vtours\TTXmlWebService\Service\Factory;
use Vtours\TTXmlWebService\Service\HotelList\Mapper as HotelMapper;
use Vtours\TTXmlWebService\Service\MappingHelper\GeneralMappingHelper;
use Vtours\TTXmlWebService\Service\OfferList\Mapper as OfferMapper;
use Vtours\TTXmlWebService\Service\RegionTRee\Mapper as RegionTreeMapper;

class HandlerTest extends TestCase
{
//    public function testTTWorking()
//    {
//        $generalMappingHelper = new GeneralMappingHelper();
//        $mapper = new Mapper($generalMappingHelper);
//
//        $serializer = \JMS\Serializer\SerializerBuilder::create()->build();
//
//        $factory = new \Vtours\TTXmlWebService\Helper\Factory();
//        $client = $factory->client();
//        $requestData = include __DIR__ . '/IffCodeRequestData.php';
//
//        $request = new DatenAngebotRequestModel();
//        $request->setCode($requestData['code'])
//            ->setCodetype($requestData['codetype'])
//            ->setOffertype($requestData['offertype'])
//            ->setTraveldateStart($requestData['traveldateStart'])
//            ->setTraveldateEnd($requestData['traveldateStart'])
//            ->setTraveldurationMin($requestData['traveldurationMin'])
//            ->setTraveldurationMax($requestData['traveldurationMax'])
//            ->setRoomtype($requestData['roomtype'])
//            ->setMealtype($requestData['mealtype'])
//            ->setBrand($requestData['brand'])
//            ->setPriceMin($requestData['priceMin'])
//            ->setPriceMax($requestData['priceMax'])
//            ->setTravellers($requestData['travellers'])
//            ->setSpecialJourneyAttributes($requestData['specialJourneyAttributes'])
//            ->setHotelAttributes($requestData['hotelAttributes'])
//            ->setDepartureAirport($requestData['departureAirport']);
//
//        $serviceHandler = new Handler($mapper, $serializer, $client, $generalMappingHelper);
//
//        $responseModel = $serviceHandler->getAllHotelOffersByHotelCode($request);
//        echo($responseModel);
//    }

    public function testRequestWillDeserializeResponse()
    {

        $mapper = $this->getMockBuilder(HotelMapper::class)->getMock();
        $offerListMapper = $this->getMockBuilder(OfferMapper::class)->getMock();
        $regionTreeMapper = $this->getMockBuilder(RegionTreeMapper::class)->getMock();
        $serializer = $this->getMockBuilder(SerializerInterface::class)->getMock();

        // Create a mock and queue the responses.
        $mock = new MockHandler([
            new Response(200, [], include __DIR__ . '/SearchEngineOfferListResponse.xml'),
        ]);

        $handler = HandlerStack::create($mock);
        $client = new Client(['handler' => $handler]);
        $generalMappingHelper = $this->getMockBuilder(GeneralMappingHelper::class)->getMock();


        $offerListHandler = new Handler($mapper, $serializer, $client, $generalMappingHelper);
        $hotelListHandler = new \Vtours\TTXmlWebService\Service\HotelList\Handler($offerListMapper, $serializer, $client, $generalMappingHelper);
        $regionTreeHandler = new \Vtours\TTXmlWebService\Service\RegionTree\Handler($regionTreeMapper, $serializer, $client, $generalMappingHelper);

        $serviceFactory = new Factory($hotelListHandler, $offerListHandler, $regionTreeHandler);
        $request = include __DIR__ . '/SearchEngineHotelListRequest.xml';
        $responseModel = $serviceFactory->hotelList()->getBestOffersByRegion($request);

        $this->assertInstanceOf(SearchEngineOfferListRS::class, $responseModel);
        // More response model assertions here ...
    }

    public function testRequestWillThrowException()
    {
        //$this->getExpectedException()

        // Mock guzzle to throw exception
//        $mock = new MockHandler([
//            new ClientException("", $this->getMockBuilder(RequestInterface::class)->getMock(), new Response(500)),
//        ]);
    }

    public function testBuildUri()
    {
        $mapper = $this->getMockBuilder(Mapper::class)->getMock();
        $serializer = $this->getMockBuilder(SerializerInterface::class)->getMock();
        $client = $this->getMockBuilder(ClientInterface::class)->getMock();
        $generalMappingHelper = $this->getMockBuilder(GeneralMappingHelper::class)->getMock();

        $serviceHandler = new Handler($mapper, $serializer, $client, $generalMappingHelper);

        $class = new \ReflectionClass(Handler::class);
        $method = $class->getMethod('buildUriFromRequest');
        $method->setAccessible(true);

        $uri = $method->invoke($serviceHandler, ['offertype' => 'test']);
        $this->assertSame('/Dispatcher/Search/test/OfferList', $uri);
    }
}