<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class MealType
 *
 * @package Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest
 */
class MealType
{

    /**
     * @var string
     * @Serializer\Inline()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("MealType")
     */
    private $mealType;

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\SerializedName("Weightage")
     */
    private $weightage;


    /**
     * @return string
     */
    public function getMealType()
    {
        return $this->mealType;
    }

    /**
     * @param string $mealType
     *
     * @return MealType
     */
    public function setMealType($mealType)
    {
        $this->mealType = $mealType;

        return $this;
    }

    /**
     * @return string
     */
    public function getWeightage()
    {
        return $this->weightage;
    }

    /**
     * @param string $weightage
     *
     * @return MealType
     */
    public function setWeightage($weightage)
    {
        $this->weightage = $weightage;

        return $this;
    }
}
