<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model;

class DatenAngebotResponseModel
{
    /**
     * @var string
     */
    private $hotelName;
    /**
     * @var string
     */
    private $hotelRegion;
    /**
     * @var int
     */
    private $hotelRegionId;
    /**
     * @var int
     */
    private $hotelCityId;
    /**
     * @var string
     */
    private $hotelCountry;
    /**
     * @var int
     */
    private $hotelStars;
    /**
     * @var int
     */
    private $regionTemperature;
    /**
     * @var string
     */
    private $hotelPictureUrl;
    /**
     * @var int
     */
    private $offerId;
    /**
     * @var string
     */
    private $offerDepartureAirport;
    /**
     * @var int
     */
    private $offerPrice;
    /**
     * @var string
     */
    private $offerMealType;
    /**
     * @var string
     */
    private $offerRoomType;
    /**
     * @var int
     */
    private $offerTravelDuration;
    /**
     * @var boolean
     */
    private $offerWithFlight;
    /**
     * @var boolean
     */
    private $offerWithTransfer;

    /**
     * @var int
     */
    private $hotelIff;

    /**
     * @var int
     */
    private $hotelGiata;

    /**
     * @var int
     */
    private $destinationId;

    /**
     * @var string
     */
    private $offerPriceCurrency;

    /**
     * @var string
     */
    private $deeplinkPrefix;

    /**
     * @var string
     */
    private $deeplinkParameter;

    /**
     * @return string
     */
    public function getHotelName()
    {
        return $this->hotelName;
    }

    /**
     * @param string $hotelName
     *
     * @return DatenAngebotResponseModel
     */
    public function setHotelName($hotelName)
    {
        $this->hotelName = $hotelName;

        return $this;
    }

    /**
     * @return string
     */
    public function getHotelRegion()
    {
        return $this->hotelRegion;
    }

    /**
     * @param string $hotelRegion
     *
     * @return DatenAngebotResponseModel
     */
    public function setHotelRegion($hotelRegion)
    {
        $this->hotelRegion = $hotelRegion;

        return $this;
    }

    /**
     * @return int
     */
    public function getHotelRegionId()
    {
        return $this->hotelRegionId;
    }

    /**
     * @param int $hotelRegionId
     *
     * @return DatenAngebotResponseModel
     */
    public function setHotelRegionId($hotelRegionId)
    {
        $this->hotelRegionId = $hotelRegionId;

        return $this;
    }

    /**
     * @return int
     */
    public function getHotelCityId()
    {
        return $this->hotelCityId;
    }

    /**
     * @param int $hotelCityId
     * @return DatenAngebotResponseModel
     */
    public function setHotelCityId($hotelCityId)
    {
        $this->hotelCityId = $hotelCityId;
        return $this;
    }

    /**
     * @return string
     */
    public function getHotelCountry()
    {
        return $this->hotelCountry;
    }

    /**
     * @param string $hotelCountry
     *
     * @return DatenAngebotResponseModel
     */
    public function setHotelCountry($hotelCountry)
    {
        $this->hotelCountry = $hotelCountry;

        return $this;
    }

    /**
     * @return int
     */
    public function getHotelStars()
    {
        return $this->hotelStars;
    }

    /**
     * @param int $hotelStars
     *
     * @return DatenAngebotResponseModel
     */
    public function setHotelStars($hotelStars)
    {
        $this->hotelStars = $hotelStars;

        return $this;
    }

    /**
     * @return int
     */
    public function getRegionTemperature()
    {
        return $this->regionTemperature;
    }

    /**
     * @param int $regionTemperature
     *
     * @return DatenAngebotResponseModel
     */
    public function setRegionTemperature($regionTemperature)
    {
        $this->regionTemperature = $regionTemperature;

        return $this;
    }

    /**
     * @return string
     */
    public function getHotelPictureUrl()
    {
        return $this->hotelPictureUrl;
    }

    /**
     * @param string $hotelPictureUrl
     *
     * @return DatenAngebotResponseModel
     */
    public function setHotelPictureUrl($hotelPictureUrl)
    {
        $this->hotelPictureUrl = $hotelPictureUrl;

        return $this;
    }

    /**
     * @return int
     */
    public function getOfferId()
    {
        return $this->offerId;
    }

    /**
     * @param int $offerId
     *
     * @return DatenAngebotResponseModel
     */
    public function setOfferId($offerId)
    {
        $this->offerId = $offerId;

        return $this;
    }

    /**
     * @return string
     */
    public function getOfferDepartureAirport()
    {
        return $this->offerDepartureAirport;
    }

    /**
     * @param string $offerDepartureAirport
     *
     * @return DatenAngebotResponseModel
     */
    public function setOfferDepartureAirport($offerDepartureAirport)
    {
        $this->offerDepartureAirport = $offerDepartureAirport;

        return $this;
    }

    /**
     * @return int
     */
    public function getOfferPrice()
    {
        return $this->offerPrice;
    }

    /**
     * @param int $offerPrice
     *
     * @return DatenAngebotResponseModel
     */
    public function setOfferPrice($offerPrice)
    {
        $this->offerPrice = $offerPrice;

        return $this;
    }

    /**
     * @return string
     */
    public function getOfferMealType()
    {
        return $this->offerMealType;
    }

    /**
     * @param string $offerMealType
     *
     * @return DatenAngebotResponseModel
     */
    public function setOfferMealType($offerMealType)
    {
        $this->offerMealType = $offerMealType;

        return $this;
    }

    /**
     * @return string
     */
    public function getOfferRoomType()
    {
        return $this->offerRoomType;
    }

    /**
     * @param string $offerRoomType
     *
     * @return DatenAngebotResponseModel
     */
    public function setOfferRoomType($offerRoomType)
    {
        $this->offerRoomType = $offerRoomType;

        return $this;
    }

    /**
     * @return int
     */
    public function getOfferTravelDuration()
    {
        return $this->offerTravelDuration;
    }

    /**
     * @param int $offerTravelDuration
     *
     * @return DatenAngebotResponseModel
     */
    public function setOfferTravelDuration($offerTravelDuration)
    {
        $this->offerTravelDuration = $offerTravelDuration;

        return $this;
    }

    /**
     * @return bool
     */
    public function isOfferWithFlight()
    {
        return $this->offerWithFlight;
    }

    /**
     * @param bool $offerWithFlight
     *
     * @return DatenAngebotResponseModel
     */
    public function setOfferWithFlight($offerWithFlight)
    {
        $this->offerWithFlight = $offerWithFlight;

        return $this;
    }

    /**
     * @return bool
     */
    public function isOfferWithTransfer()
    {
        return $this->offerWithTransfer;
    }

    /**
     * @param bool $offerWithTransfer
     *
     * @return DatenAngebotResponseModel
     */
    public function setOfferWithTransfer($offerWithTransfer)
    {
        $this->offerWithTransfer = $offerWithTransfer;

        return $this;
    }

    /**
     * @return int
     */
    public function getHotelIff()
    {
        return $this->hotelIff;
    }

    /**
     * @param int $hotelIff
     *
     * @return DatenAngebotResponseModel
     */
    public function setHotelIff($hotelIff)
    {
        $this->hotelIff = $hotelIff;

        return $this;
    }

    /**
     * @return int
     */
    public function getHotelGiata()
    {
        return $this->hotelGiata;
    }

    /**
     * @param int $hotelGiata
     *
     * @return DatenAngebotResponseModel
     */
    public function setHotelGiata($hotelGiata)
    {
        $this->hotelGiata = $hotelGiata;

        return $this;
    }

    /**
     * @return int
     */
    public function getDestinationId()
    {
        return $this->destinationId;
    }

    /**
     * @param int $destinationId
     *
     * @return DatenAngebotResponseModel
     */
    public function setDestinationId($destinationId)
    {
        $this->destinationId = $destinationId;

        return $this;
    }

    /**
     * @return string
     */
    public function getOfferPriceCurrency()
    {
        return $this->offerPriceCurrency;
    }

    /**
     * @param string $offerPriceCurrency
     *
     * @return DatenAngebotResponseModel
     */
    public function setOfferPriceCurrency($offerPriceCurrency)
    {
        $this->offerPriceCurrency = $offerPriceCurrency;

        return $this;
    }

    /**
     * @return string
     */
    public function getDeeplinkPrefix()
    {
        return $this->deeplinkPrefix;
    }

    /**
     * @param string $deeplinkPrefix
     *
     * @return DatenAngebotResponseModel
     */
    public function setDeeplinkPrefix($deeplinkPrefix)
    {
        $this->deeplinkPrefix = $deeplinkPrefix;

        return $this;
    }

    /**
     * @return string
     */
    public function getDeeplinkParameter()
    {
        return $this->deeplinkParameter;
    }

    /**
     * @param string $deeplinkParameter
     *
     * @return DatenAngebotResponseModel
     */
    public function setDeeplinkParameter($deeplinkParameter)
    {
        $this->deeplinkParameter = $deeplinkParameter;

        return $this;
    }
}
