<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\PriceResponse;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ConvertedPrice
 *
 * @package Vtours\TTXmlWebService\Model\Response\PriceResponse
 */
class ConvertedPrice
{
    /**
     * @var float
     * @Serializer\XmlValue()
     * @Serializer\Type("float")
     * @Serializer\SerializedName("ConvertedPrice")
     */
    private $convertedPrice;

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Currency")
     */
    private $currency;

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ExchangeRate")
     */
    private $exchangeRate;

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("OriginalCurrency")
     */
    private $originalCurrency;



    /**
     * @return float
     */
    public function getConvertedPrice()
    {
        return $this->convertedPrice;
    }

    /**
     * @param float $convertedPrice
     *
     * @return ConvertedPrice
     */
    public function setConvertedPrice($convertedPrice)
    {
        $this->convertedPrice = $convertedPrice;

        return $this;
    }

    /**
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     *
     * @return ConvertedPrice
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;

        return $this;
    }

    /**
     * @return string
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }

    /**
     * @param string $exchangeRate
     *
     * @return ConvertedPrice
     */
    public function setExchangeRate($exchangeRate)
    {
        $this->exchangeRate = $exchangeRate;

        return $this;
    }

    /**
     * @return string
     */
    public function getOriginalCurrency()
    {
        return $this->originalCurrency;
    }

    /**
     * @param string $originalCurrency
     *
     * @return ConvertedPrice
     */
    public function setOriginalCurrency($originalCurrency)
    {
        $this->originalCurrency = $originalCurrency;

        return $this;
    }
}
