<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\FlightResponse;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class FlightSegment
 *
 * @package Vtours\TTXmlWebService\Model\Response\FlightResponse
 */
class FlightSegment
{

    /**
     * @var string
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\FlightResponse\Airport")
     * @Serializer\SerializedName("DepartureAirport")
     */
    private $dapartureAirport;

    /**
     * @var string
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\FlightResponse\Airport")
     * @Serializer\SerializedName("DestinationAirport")
     */
    private $destinationAirport;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("FlightNumber")
     */
    private $flightNumber;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Airline")
     */
    private $airline;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("OperatingAirline")
     */
    private $opertaingAirline;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("CarrierCode")
     */
    private $carrierCode;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("CarrierCodeOperatedBy")
     */
    private $carrierCodeOperatedBy;

    /**
     * @var int
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\FlightResponse\FlightDateTimeSpan")
     * @Serializer\SerializedName("FlightDateTimeSpan")
     */
    private $flightDateTimeSpan;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("NumberOfStops")
     */
    private $numberOfStops;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("FlightClass")
     */
    private $flightClass;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("FlightDuration")
     */
    private $flightDuration;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ServiceClass")
     */
    private $serviceClass;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("FlightEquipment")
     */
    private $flightEquipment;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("FareBase")
     */
    private $fareBase;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("DepartureTerminal")
     */
    private $departureTerminal;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ArrivalTerminal")
     */
    private $arrivalTerminal;

    /**
     * @var BaggageAllowance
     * @Serializer\Type("BaggageAllowance")
     * @Serializer\SerializedName("BaggageAllowance")
     */
    private $baggageAllowance;

    /**
     * @return string
     */
    public function getDapartureAirport()
    {
        return $this->dapartureAirport;
    }

    /**
     * @param string $dapartureAirport
     *
     * @return FlightSegment
     */
    public function setDapartureAirport($dapartureAirport)
    {
        $this->dapartureAirport = $dapartureAirport;

        return $this;
    }

    /**
     * @return string
     */
    public function getDestinationAirport()
    {
        return $this->destinationAirport;
    }

    /**
     * @param string $destinationAirport
     *
     * @return FlightSegment
     */
    public function setDestinationAirport($destinationAirport)
    {
        $this->destinationAirport = $destinationAirport;

        return $this;
    }

    /**
     * @return string
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }

    /**
     * @param string $flightNumber
     *
     * @return FlightSegment
     */
    public function setFlightNumber($flightNumber)
    {
        $this->flightNumber = $flightNumber;

        return $this;
    }

    /**
     * @return string
     */
    public function getAirline()
    {
        return $this->airline;
    }

    /**
     * @param string $airline
     *
     * @return FlightSegment
     */
    public function setAirline($airline)
    {
        $this->airline = $airline;

        return $this;
    }

    /**
     * @return string
     */
    public function getOpertaingAirline()
    {
        return $this->opertaingAirline;
    }

    /**
     * @param string $opertaingAirline
     *
     * @return FlightSegment
     */
    public function setOpertaingAirline($opertaingAirline)
    {
        $this->opertaingAirline = $opertaingAirline;

        return $this;
    }

    /**
     * @return string
     */
    public function getCarrierCode()
    {
        return $this->carrierCode;
    }

    /**
     * @param string $carrierCode
     *
     * @return FlightSegment
     */
    public function setCarrierCode($carrierCode)
    {
        $this->carrierCode = $carrierCode;

        return $this;
    }

    /**
     * @return string
     */
    public function getCarrierCodeOperatedBy()
    {
        return $this->carrierCodeOperatedBy;
    }

    /**
     * @param string $carrierCodeOperatedBy
     *
     * @return FlightSegment
     */
    public function setCarrierCodeOperatedBy($carrierCodeOperatedBy)
    {
        $this->carrierCodeOperatedBy = $carrierCodeOperatedBy;

        return $this;
    }

    /**
     * @return int
     */
    public function getFlightDateTimeSpan()
    {
        return $this->flightDateTimeSpan;
    }

    /**
     * @param int $flightDateTimeSpan
     *
     * @return FlightSegment
     */
    public function setFlightDateTimeSpan($flightDateTimeSpan)
    {
        $this->flightDateTimeSpan = $flightDateTimeSpan;

        return $this;
    }

    /**
     * @return int
     */
    public function getNumberOfStops()
    {
        return $this->numberOfStops;
    }

    /**
     * @param int $numberOfStops
     *
     * @return FlightSegment
     */
    public function setNumberOfStops($numberOfStops)
    {
        $this->numberOfStops = $numberOfStops;

        return $this;
    }

    /**
     * @return string
     */
    public function getFlightClass()
    {
        return $this->flightClass;
    }

    /**
     * @param string $flightClass
     *
     * @return FlightSegment
     */
    public function setFlightClass($flightClass)
    {
        $this->flightClass = $flightClass;

        return $this;
    }

    /**
     * @return string
     */
    public function getFlightDuration()
    {
        return $this->flightDuration;
    }

    /**
     * @param string $flightDuration
     *
     * @return FlightSegment
     */
    public function setFlightDuration($flightDuration)
    {
        $this->flightDuration = $flightDuration;

        return $this;
    }

    /**
     * @return string
     */
    public function getServiceClass()
    {
        return $this->serviceClass;
    }

    /**
     * @param string $serviceClass
     *
     * @return FlightSegment
     */
    public function setServiceClass($serviceClass)
    {
        $this->serviceClass = $serviceClass;

        return $this;
    }

    /**
     * @return string
     */
    public function getFlightEquipment()
    {
        return $this->flightEquipment;
    }

    /**
     * @param string $flightEquipment
     *
     * @return FlightSegment
     */
    public function setFlightEquipment($flightEquipment)
    {
        $this->flightEquipment = $flightEquipment;

        return $this;
    }

    /**
     * @return string
     */
    public function getFareBase()
    {
        return $this->fareBase;
    }

    /**
     * @param string $fareBase
     *
     * @return FlightSegment
     */
    public function setFareBase($fareBase)
    {
        $this->fareBase = $fareBase;

        return $this;
    }

    /**
     * @return string
     */
    public function getDepartureTerminal()
    {
        return $this->departureTerminal;
    }

    /**
     * @param string $departureTerminal
     *
     * @return FlightSegment
     */
    public function setDepartureTerminal($departureTerminal)
    {
        $this->departureTerminal = $departureTerminal;

        return $this;
    }

    /**
     * @return string
     */
    public function getArrivalTerminal()
    {
        return $this->arrivalTerminal;
    }

    /**
     * @param string $arrivalTerminal
     *
     * @return FlightSegment
     */
    public function setArrivalTerminal($arrivalTerminal)
    {
        $this->arrivalTerminal = $arrivalTerminal;

        return $this;
    }

    /**
     * @return BaggageAllowance
     */
    public function getBaggageAllowance()
    {
        return $this->baggageAllowance;
    }

    /**
     * @param BaggageAllowance $baggageAllowance
     *
     * @return FlightSegment
     */
    public function setBaggageAllowance($baggageAllowance)
    {
        $this->baggageAllowance = $baggageAllowance;

        return $this;
    }
}
