<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("root")
 * @Serializer\AccessType("public_method")
 */
class TestRequest
{
    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("MinDays")
     */
    private $minDays;


    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("MaxDays")
     */
    private $maxDays;

    /**
     * @return int
     */
    public function getMinDays()
    {
        return $this->minDays;
    }

    /**
     * @param int $minDays
     *
     * @return TestRequest
     */
    public function setMinDays($minDays)
    {
        $this->minDays = $minDays;

        return $this;
    }

    /**
     * @return int
     */
    public function getMaxDays()
    {
        return $this->maxDays;
    }

    /**
     * @param int $maxDays
     *
     * @return TestRequest
     */
    public function setMaxDays($maxDays)
    {
        $this->maxDays = $maxDays;

        return $this;
    }
}
