<?php

namespace Vtours\TTXmlWebService\Model\Request\V2\OfferFilters;

use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Request\V2\OfferFilters\DateRange;

/**
 * @Serializer\ExclusionPolicy("all")
 */
class InboundTransportDateAndTimeFilter
{
    /**
     * @Serializer\Expose()
     * @Serializer\SerializedName("DateRange")
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\V2\OfferFilters\DateRange")
     * @var DateRange
     */
    private $dateRange;

    /**
     * @return DateRange
     */
    public function getDateRange()
    {
        return $this->dateRange;
    }

    /**
     * @param DateRange $dateRange
     */
    public function setDateRange($dateRange)
    {
        $this->dateRange = $dateRange;
    }
}
