<?php

namespace Vtours\TTXmlWebService\Model\Request\V2;


use JMS\Serializer\Annotation as Serializer;


/**
 * @Serializer\ExclusionPolicy("all")
 */
class RQMeta
{

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Language")
     *
     * @var string
     */
    private $language = "de-DE";

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("RequestID")
     *
     * @var string
     */
    private $RequestId;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TransactionID")
     *
     * @var string
     */
    private $TransactonId;

    /**
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * @param string $language
     */
    public function setLanguage($language)
    {
        $this->language = $language;
    }

    /**
     * @return string
     */
    public function getRequestId()
    {
        return $this->RequestId;
    }

    /**
     * @param string $RequestId
     */
    public function setRequestId($RequestId)
    {
        $this->RequestId = $RequestId;
    }

    /**
     * @return string
     */
    public function getTransactonId()
    {
        return $this->TransactonId;
    }

    /**
     * @param string $TransactonId
     */
    public function setTransactonId($TransactonId)
    {
        $this->TransactonId = $TransactonId;
    }
}
