<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;

use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Response\WeatherResponse\WeatherForRegion;

/**
 * Class Region
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class Region
{
    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Country")
     */
    private $country;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Region")
     */
    private $region;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("RegionRefID")
     */
    private $regionRefId;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("DestinationID")
     */
    private $destinationId;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("TopRegionID")
     */
    private $topRegionId;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("DestinationAirport")
     */
    private $destinationAirport;

    /**
     * @var WeatherForRegion
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\WeatherResponse\WeatherForRegion")
     * @Serializer\SerializedName("WeatherForRegion")
     */
    private $weatherForRegion;


    /**
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * @param string $country
     *
     * @return Region
     */
    public function setCountry($country)
    {
        $this->country = $country;

        return $this;
    }

    /**
     * @return string
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * @param string $region
     *
     * @return Region
     */
    public function setRegion($region)
    {
        $this->region = $region;

        return $this;
    }

    /**
     * @return int
     */
    public function getRegionRefId()
    {
        return $this->regionRefId;
    }

    /**
     * @param int $regionRefId
     *
     * @return Region
     */
    public function setRegionRefId($regionRefId)
    {
        $this->regionRefId = $regionRefId;

        return $this;
    }

    /**
     * @return int
     */
    public function getDestinationId()
    {
        return $this->destinationId;
    }

    /**
     * @param int $destinationId
     *
     * @return Region
     */
    public function setDestinationId($destinationId)
    {
        $this->destinationId = $destinationId;

        return $this;
    }

    /**
     * @return int
     */
    public function getTopRegionId()
    {
        return $this->topRegionId;
    }

    /**
     * @param int $topRegionId
     *
     * @return Region
     */
    public function setTopRegionId($topRegionId)
    {
        $this->topRegionId = $topRegionId;

        return $this;
    }

    /**
     * @return string
     */
    public function getDestinationAirport()
    {
        return $this->destinationAirport;
    }

    /**
     * @param string $destinationAirport
     *
     * @return Region
     */
    public function setDestinationAirport($destinationAirport)
    {
        $this->destinationAirport = $destinationAirport;

        return $this;
    }

    /**
     * @return WeatherForRegion
     */
    public function getWeatherForRegion()
    {
        return $this->weatherForRegion;
    }

    /**
     * @param WeatherForRegion $weatherForRegion
     *
     * @return Region
     */
    public function setWeatherForRegion($weatherForRegion)
    {
        $this->weatherForRegion = $weatherForRegion;

        return $this;
    }
}
