<?php
namespace Vtours\TTXmlWebService\Model\Response\V2\GeoDictionary;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\Metadata;
use Vtours\TTXmlWebService\Model\Response\V2\GeoDictionary\Continent;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class Continents
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\V2\GeoDictionary\Continent>")
     * @Serializer\SerializedName("Continent")
     *
     * @var array|Continent[]
     */
    private $continent;

    /**
     * @return array|Continent[]
     */
    public function getContinent()
    {
        return $this->continent;
    }

    /**
     * @param array|Continent[] $continent
     */
    public function setContinent($continent)
    {
        $this->continent = $continent;
    }
}
